/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.condition.forge;

import com.google.gson.JsonObject;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class FluidExistsCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("pollen", "fluid_exists");
    private final ResourceLocation fluid;

    public FluidExistsCondition(ResourceLocation fluid) {
        this.fluid = fluid;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return ForgeRegistries.FLUIDS.containsKey(this.fluid);
    }

    public String toString() {
        return "fluid_exists(\"" + this.fluid + "\")";
    }

    public static class Serializer
    implements IConditionSerializer<FluidExistsCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, FluidExistsCondition value) {
            json.addProperty("fluid", value.fluid.toString());
        }

        public FluidExistsCondition read(JsonObject json) {
            return new FluidExistsCondition(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

