/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.modifier;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierManager;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.ResourceLocation;

public abstract class ResourceModifier<T> {
    protected final ResourceLocation id;
    protected final ResourceLocation[] inject;
    protected final int priority;

    protected ResourceModifier(ResourceLocation id, ResourceLocation[] inject, int priority) {
        this.id = id;
        this.inject = inject;
        this.priority = priority;
    }

    public abstract void modify(T var1) throws JsonParseException;

    public abstract Builder<?, ?> deconstruct();

    public abstract ResourceModifierType getType();

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation[] getInject() {
        return this.inject;
    }

    public int getInjectPriority() {
        return this.priority;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceModifier that = (ResourceModifier)o;
        return this.id.equals((Object)that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static abstract class Builder<T extends ResourceModifier<?>, V> {
        protected final List<ResourceLocation> inject;
        protected int priority;

        protected Builder() {
            this.inject = new LinkedList<ResourceLocation>();
            this.priority = 1000;
        }

        protected Builder(ResourceLocation[] inject, int priority) {
            this.inject = new LinkedList<ResourceLocation>(Arrays.asList(inject));
            this.priority = priority;
        }

        protected abstract V getThis();

        protected abstract ResourceModifierType getType();

        public V injectInto(ResourceLocation id) {
            this.inject.add(id);
            return this.getThis();
        }

        public V injectPriority(int priority) {
            this.priority = priority;
            return this.getThis();
        }

        public abstract T build(ResourceLocation var1);

        public T save(Consumer<T> consumer, ResourceLocation id) {
            T modifier = this.build(id);
            consumer.accept(modifier);
            return modifier;
        }

        public final JsonObject serializeToJson() {
            if (this.inject.isEmpty()) {
                throw new IllegalStateException("'inject' must be defined");
            }
            JsonObject json = new JsonObject();
            json.addProperty("type", String.valueOf(ResourceModifierManager.REGISTRY.getKey(this.getType())));
            if (this.inject.size() == 1) {
                json.addProperty("inject", this.inject.get(0).toString());
            } else {
                JsonArray injectJson = new JsonArray();
                for (ResourceLocation inject : this.inject) {
                    injectJson.add(inject.toString());
                }
                json.add("inject", (JsonElement)injectJson);
            }
            if (this.priority != 1000) {
                json.addProperty("priority", (Number)this.priority);
            }
            this.serializeProperties(json);
            return json;
        }

        protected void serializeProperties(JsonObject json) {
        }
    }
}

