/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.resource.modifier.type;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.architectury.injectables.annotations.ExpectPlatform;
import gg.moonflower.pollen.api.event.events.LootTableConstructingEvent;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifier;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierManager;
import gg.moonflower.pollen.api.resource.modifier.ResourceModifierType;
import gg.moonflower.pollen.api.resource.modifier.type.forge.LootModifierImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class LootModifier
extends ResourceModifier<LootTableConstructingEvent.Context> {
    private static final Gson GSON = LootModifier.createLootTableSerializer().create();
    private final LootParameterSet lootContextParamSet;
    private final LootPool[] addPools;
    private final ILootFunction[] addFunctions;
    private final Map<Integer, List<LootPool>> injectPools;
    private final Map<Integer, Set<Integer>> removePoolEntries;
    private final Map<Integer, Set<Integer>> removePoolConditions;
    private final Map<Integer, Set<Integer>> removePoolFunctions;
    private final int[] removePools;
    private final int[] removeFunctions;

    public LootModifier(ResourceLocation id, ResourceLocation[] inject, int priority, LootParameterSet lootContextParamSet, LootPool[] addPools, ILootFunction[] addFunctions, Map<Integer, List<LootPool>> injectPools, Map<Integer, Set<Integer>> removePoolEntries, Map<Integer, Set<Integer>> removePoolConditions, Map<Integer, Set<Integer>> removePoolFunctions, int[] removePools, int[] removeFunctions) {
        super(id, inject, priority);
        this.lootContextParamSet = lootContextParamSet;
        this.addPools = addPools;
        this.addFunctions = addFunctions;
        this.injectPools = injectPools;
        this.removePoolEntries = removePoolEntries;
        this.removePoolConditions = removePoolConditions;
        this.removePoolFunctions = removePoolFunctions;
        this.removePools = removePools;
        this.removeFunctions = removeFunctions;
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static GsonBuilder createLootTableSerializer() {
        return LootModifierImpl.createLootTableSerializer();
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void initPool(JsonObject json) {
        LootModifierImpl.initPool(json);
    }

    public static Builder lootModifier() {
        return new Builder();
    }

    public Builder deconstruct() {
        return new Builder(this.inject, this.priority, this.lootContextParamSet, this.addPools, this.addFunctions, this.injectPools, this.removePoolEntries, this.removePoolConditions, this.removePoolFunctions, this.removePools, this.removeFunctions);
    }

    @Override
    public void modify(LootTableConstructingEvent.Context resource) throws JsonParseException {
        int n;
        if (this.lootContextParamSet != null) {
            resource.setParamSet(this.lootContextParamSet);
        }
        LootPool[] lootPoolArray = this.addPools;
        int n2 = lootPoolArray.length;
        for (n = 0; n < n2; ++n) {
            LootPool lootPool = lootPoolArray[n];
            resource.addPool(lootPool);
        }
        ILootFunction[] iLootFunctionArray = this.addFunctions;
        int n3 = iLootFunctionArray.length;
        for (n = 0; n < n3; ++n) {
            ILootFunction iLootFunction = iLootFunctionArray[n];
            resource.addFunction(iLootFunction);
        }
        for (Map.Entry<Integer, List<LootPool>> entry : this.injectPools.entrySet()) {
            resource.insertPool((int)entry.getKey(), entry.getValue().toArray(new LootPool[0]));
        }
        for (Map.Entry<Integer, Set<Integer>> entry : this.removePoolEntries.entrySet()) {
            for (int n4 : entry.getValue()) {
                resource.removeEntry(entry.getKey(), n4);
            }
        }
        for (Map.Entry<Integer, Set<Integer>> entry : this.removePoolConditions.entrySet()) {
            for (int n5 : entry.getValue()) {
                resource.removeCondition(entry.getKey(), n5);
            }
        }
        for (Map.Entry<Integer, Set<Integer>> entry : this.removePoolFunctions.entrySet()) {
            for (int n6 : entry.getValue()) {
                resource.removeFunction(entry.getKey(), n6);
            }
        }
        int[] nArray = this.removePools;
        int n7 = nArray.length;
        for (n = 0; n < n7; ++n) {
            int n8 = nArray[n];
            resource.removePool(n8);
        }
        for (int n9 : this.removeFunctions) {
            resource.removeFunction(n9);
        }
    }

    @Override
    public ResourceModifierType getType() {
        return ResourceModifierManager.LOOT.get();
    }

    public static class Builder
    extends ResourceModifier.Builder<LootModifier, Builder> {
        private LootParameterSet lootContextParamSet;
        private final List<LootPool> addPools;
        private final List<ILootFunction> addFunctions;
        private final Map<Integer, List<LootPool>> injectPools;
        private final Map<Integer, Set<Integer>> removePoolEntries;
        private final Map<Integer, Set<Integer>> removePoolConditions;
        private final Map<Integer, Set<Integer>> removePoolFunctions;
        private final List<Integer> removePools;
        private final List<Integer> removeFunctions;

        private Builder(ResourceLocation[] inject, int priority, @Nullable LootParameterSet lootContextParamSet, LootPool[] addPools, ILootFunction[] addFunctions, Map<Integer, List<LootPool>> injectPools, Map<Integer, Set<Integer>> removePoolEntries, Map<Integer, Set<Integer>> removePoolConditions, Map<Integer, Set<Integer>> removePoolFunctions, int[] removePools, int[] removeFunctions) {
            super(inject, priority);
            this.lootContextParamSet = lootContextParamSet;
            this.addPools = new LinkedList<LootPool>(Arrays.asList(addPools));
            this.addFunctions = new LinkedList<ILootFunction>(Arrays.asList(addFunctions));
            this.injectPools = injectPools;
            this.removePoolEntries = removePoolEntries;
            this.removePoolConditions = removePoolConditions;
            this.removePoolFunctions = removePoolFunctions;
            this.removePools = IntStream.of(removePools).boxed().collect(Collectors.toCollection(LinkedList::new));
            this.removeFunctions = IntStream.of(removeFunctions).boxed().collect(Collectors.toCollection(LinkedList::new));
        }

        private Builder() {
            this.lootContextParamSet = null;
            this.addPools = new LinkedList<LootPool>();
            this.addFunctions = new LinkedList<ILootFunction>();
            this.injectPools = new HashMap<Integer, List<LootPool>>();
            this.removePoolEntries = new HashMap<Integer, Set<Integer>>();
            this.removePoolConditions = new HashMap<Integer, Set<Integer>>();
            this.removePoolFunctions = new HashMap<Integer, Set<Integer>>();
            this.removePools = new LinkedList<Integer>();
            this.removeFunctions = new LinkedList<Integer>();
        }

        public Builder setLootContextParamSet(@Nullable LootParameterSet lootContextParamSet) {
            this.lootContextParamSet = lootContextParamSet;
            return this;
        }

        public Builder addPool(LootPool pool) {
            this.addPools.add(pool);
            return this;
        }

        public Builder addFunction(ILootFunction function) {
            this.addFunctions.add(function);
            return this;
        }

        public Builder injectPool(int poolIndex, LootPool pool) {
            this.injectPools.computeIfAbsent(poolIndex, __ -> new ArrayList()).add(pool);
            return this;
        }

        public Builder removePoolEntry(int poolIndex, int entryIndex) {
            this.removePoolEntries.computeIfAbsent(poolIndex, __ -> new HashSet()).add(entryIndex);
            return this;
        }

        public Builder removePoolCondition(int poolIndex, int conditionEntry) {
            this.removePoolConditions.computeIfAbsent(poolIndex, __ -> new HashSet()).add(conditionEntry);
            return this;
        }

        public Builder removePoolFunction(int poolIndex, int functionEntry) {
            this.removePoolFunctions.computeIfAbsent(poolIndex, __ -> new HashSet()).add(functionEntry);
            return this;
        }

        public Builder removePool(int index) {
            this.removePools.add(index);
            return this;
        }

        public Builder removeFunction(int index) {
            this.removeFunctions.add(index);
            return this;
        }

        public static Builder fromJson(ResourceLocation name, DataPackRegistries serverResources, JsonObject json, ResourceLocation[] inject, int priority) {
            LootModifier.initPool(json);
            LootPool[] addPools = json.has("addPools") ? (LootPool[])GSON.fromJson(json.get("addPools"), LootPool[].class) : new LootPool[]{};
            ILootFunction[] addFunctions = json.has("addFunctions") ? (ILootFunction[])GSON.fromJson(json.get("addFunctions"), ILootFunction[].class) : new ILootFunction[]{};
            LootParameterSet lootContextParamSet = null;
            if (json.has("type")) {
                String string = JSONUtils.func_151200_h((JsonObject)json, (String)"type");
                lootContextParamSet = LootParameterSets.func_216256_a((ResourceLocation)new ResourceLocation(string));
            }
            HashMap<Integer, List<LootPool>> injectPools = new HashMap<Integer, List<LootPool>>();
            if (json.has("injectPools")) {
                JsonArray injectPoolsJson = JSONUtils.func_151214_t((JsonObject)json, (String)"injectPools");
                for (int i = 0; i < injectPoolsJson.size(); ++i) {
                    JsonObject injectPoolJson = JSONUtils.func_151210_l((JsonElement)injectPoolsJson.get(i), (String)("injectPools[" + i + "]"));
                    int index = JSONUtils.func_151203_m((JsonObject)injectPoolJson, (String)"index");
                    injectPoolJson.addProperty("rolls", (Number)0);
                    if (!injectPoolJson.has("entries")) {
                        injectPoolJson.add("entries", (JsonElement)new JsonArray());
                    }
                    injectPools.computeIfAbsent(index, __ -> new ArrayList()).add((LootPool)GSON.fromJson((JsonElement)injectPoolJson, LootPool.class));
                }
            }
            Map<Integer, Set<Integer>> removePoolEntries = Builder.deserializeEntries(json, "removePoolEntries");
            Map<Integer, Set<Integer>> removePoolConditions = Builder.deserializeEntries(json, "removePoolConditions");
            Map<Integer, Set<Integer>> removePoolFunctions = Builder.deserializeEntries(json, "removePoolFunctions");
            int[] removePools = json.has("removePools") ? (int[])GSON.fromJson(json.get("removePools"), int[].class) : new int[]{};
            int[] removeFunctions = json.has("removeFunctions") ? (int[])GSON.fromJson(json.get("removeFunctions"), int[].class) : new int[]{};
            return new Builder(inject, priority, lootContextParamSet, addPools, addFunctions, injectPools, removePoolEntries, removePoolConditions, removePoolFunctions, removePools, removeFunctions);
        }

        private static Map<Integer, Set<Integer>> deserializeEntries(JsonObject json, String key) {
            HashMap<Integer, Set<Integer>> map = new HashMap<Integer, Set<Integer>>();
            if (json.has(key)) {
                JsonArray removePoolEntriesJson = JSONUtils.func_151214_t((JsonObject)json, (String)key);
                for (int i = 0; i < removePoolEntriesJson.size(); ++i) {
                    int[] indices;
                    JsonObject removePoolEntryJson = JSONUtils.func_151210_l((JsonElement)removePoolEntriesJson.get(i), (String)(key + "[" + i + "]"));
                    int poolIndex = JSONUtils.func_151203_m((JsonObject)removePoolEntryJson, (String)"poolIndex");
                    if (!removePoolEntryJson.has("index")) {
                        throw new JsonSyntaxException("Missing index, expected to find an Int or Int Array");
                    }
                    if (removePoolEntryJson.isJsonArray()) {
                        JsonArray removePoolEntryJsonArray = removePoolEntryJson.getAsJsonArray("index");
                        indices = new int[removePoolEntryJsonArray.size()];
                        for (int j = 0; j < removePoolEntryJsonArray.size(); ++j) {
                            indices[j] = JSONUtils.func_151215_f((JsonElement)removePoolEntryJsonArray.get(j), (String)("index[" + j + "]"));
                        }
                    } else {
                        indices = new int[]{JSONUtils.func_151203_m((JsonObject)removePoolEntryJson, (String)"index")};
                    }
                    for (int index : indices) {
                        if (map.computeIfAbsent(poolIndex, __ -> new HashSet()).add(index)) continue;
                        throw new IllegalStateException("Duplicate index: pool " + poolIndex + "[" + index + "]");
                    }
                }
            }
            return map;
        }

        private static void serializeEntries(JsonObject json, String key, Map<Integer, Set<Integer>> map) {
            if (map.isEmpty()) {
                return;
            }
            JsonArray removePoolEntriesJson = new JsonArray();
            for (Map.Entry<Integer, Set<Integer>> entry : map.entrySet()) {
                Set<Integer> indices = entry.getValue();
                if (indices.isEmpty()) continue;
                JsonObject removePoolEntryJson = new JsonObject();
                removePoolEntryJson.addProperty("poolIndex", (Number)entry.getKey());
                if (indices.size() > 1) {
                    JsonArray removePoolEntryJsonArray = new JsonArray();
                    indices.stream().sorted().forEach(arg_0 -> ((JsonArray)removePoolEntryJsonArray).add(arg_0));
                    removePoolEntryJson.add("index", (JsonElement)removePoolEntryJsonArray);
                } else {
                    removePoolEntryJson.addProperty("index", (Number)Iterables.getFirst(indices, (Object)0));
                }
                removePoolEntriesJson.add((JsonElement)json);
            }
            json.add(key, (JsonElement)removePoolEntriesJson);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        protected ResourceModifierType getType() {
            return ResourceModifierManager.LOOT.get();
        }

        @Override
        public LootModifier build(ResourceLocation id) {
            if (this.inject.isEmpty()) {
                throw new IllegalStateException("'inject' must be defined");
            }
            return new LootModifier(id, this.inject.toArray(new ResourceLocation[0]), this.priority, this.lootContextParamSet, this.addPools.toArray(new LootPool[0]), this.addFunctions.toArray(new ILootFunction[0]), this.injectPools, this.removePoolEntries, this.removePoolConditions, this.removePoolFunctions, this.removePools.stream().mapToInt(Integer::intValue).toArray(), this.removeFunctions.stream().mapToInt(Integer::intValue).toArray());
        }

        @Override
        protected void serializeProperties(JsonObject json) {
            ResourceLocation id;
            if (!this.addPools.isEmpty()) {
                json.add("pools", GSON.toJsonTree(this.addPools));
            }
            if (!this.addFunctions.isEmpty()) {
                json.add("functions", GSON.toJsonTree(this.addFunctions));
            }
            if (this.lootContextParamSet != null && (id = LootParameterSets.func_216257_a((LootParameterSet)this.lootContextParamSet)) != null) {
                json.addProperty("type", id.toString());
            }
            if (!this.injectPools.isEmpty()) {
                JsonArray injectPoolsJson = JSONUtils.func_151214_t((JsonObject)json, (String)"injectPools");
                for (Map.Entry<Integer, List<LootPool>> entry : this.injectPools.entrySet()) {
                    int index = entry.getKey();
                    for (LootPool pool : entry.getValue()) {
                        JsonObject injectPoolJson = new JsonObject();
                        injectPoolJson.addProperty("index", (Number)index);
                        injectPoolJson.add("pool", GSON.toJsonTree((Object)pool));
                        injectPoolsJson.add((JsonElement)injectPoolJson);
                    }
                }
                json.add("injectPools", (JsonElement)injectPoolsJson);
            }
            Builder.serializeEntries(json, "removePoolEntries", this.removePoolEntries);
            Builder.serializeEntries(json, "removePoolConditions", this.removePoolConditions);
            Builder.serializeEntries(json, "removePoolFunctions", this.removePoolFunctions);
            if (!this.removePools.isEmpty()) {
                JsonArray removePoolsJson = new JsonArray();
                this.removePools.stream().sorted().forEach(arg_0 -> ((JsonArray)removePoolsJson).add(arg_0));
                json.add("removePools", (JsonElement)removePoolsJson);
            }
            if (!this.removeFunctions.isEmpty()) {
                JsonArray removeFunctionsJson = new JsonArray();
                this.removeFunctions.stream().sorted().forEach(arg_0 -> ((JsonArray)removeFunctionsJson).add(arg_0));
                json.add("removeFunctions", (JsonElement)removeFunctionsJson);
            }
        }
    }
}

