/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import gg.moonflower.pollen.api.sync.SyncedDataKey;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public abstract class DataComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Map<SyncedDataKey<?>, Object> values = new HashMap();
    protected final Set<Integer> dirtyValues = ConcurrentHashMap.newKeySet();

    protected DataComponent() {
    }

    public <T> T getValue(SyncedDataKey<T> key) {
        return (T)this.values.computeIfAbsent(key, k -> k.getDefaultValueSupplier().get());
    }

    public <T> void setValue(SyncedDataKey<T> key, T value) {
        T oldValue = this.getValue(key);
        this.values.put(key, value);
        if (!Objects.equals(oldValue, value)) {
            this.dirtyValues.add(SyncedDataManager.getId(key));
        }
    }

    public boolean shouldSyncWith(Entity provider, Entity entity) {
        return this.values.keySet().stream().map(key -> provider == entity && key.getSyncStrategy().isSyncEntity() || key.getSyncStrategy().isSyncTracking()).reduce(false, (a, b) -> a != false || b != false);
    }

    public boolean shouldCopyForRespawn(boolean lossless, boolean keepInventory) {
        return this.values.keySet().stream().map(SyncedDataKey::isPersistent).reduce(false, (a, b) -> a != false || b != false);
    }

    public void copyForRespawn(DataComponent original, boolean lossless) {
        CompoundNBT tag = new CompoundNBT();
        original.writeToNbt(tag, lossless ? NbtWriteMode.COPY : NbtWriteMode.RESPAWN);
        this.readFromNbt(tag);
    }

    public void clean() {
        this.dirtyValues.clear();
    }

    public boolean isDirty() {
        return !this.dirtyValues.isEmpty();
    }

    public void readFromNbt(CompoundNBT nbt) {
        for (String key : nbt.func_150296_c()) {
            INBT tag = nbt.func_74781_a(key);
            try {
                ResourceLocation name = new ResourceLocation(key);
                SyncedDataKey<?> syncedDataKey = SyncedDataManager.byName(name);
                if (syncedDataKey == null) {
                    throw new IllegalStateException("Unknown synced data key: " + name);
                }
                this.values.put(syncedDataKey, this.readWithCodec(syncedDataKey, tag));
            }
            catch (Exception e) {
                LOGGER.error("Failed to decode " + key + " from NBT: " + tag, (Throwable)e);
            }
        }
    }

    public void writeToNbt(CompoundNBT nbt, NbtWriteMode mode) {
        for (Map.Entry<SyncedDataKey<?>, Object> entry : this.values.entrySet()) {
            SyncedDataKey<?> key = entry.getKey();
            if (mode == NbtWriteMode.SAVE && !key.isSave() || mode == NbtWriteMode.RESPAWN && !key.isPersistent()) continue;
            this.writeWithCodec(key).ifPresent(tag -> nbt.func_218657_a(key.getKey().toString(), tag));
        }
    }

    protected void writePacketData(PacketBuffer buf, int[] ids) {
        buf.func_150787_b(ids.length);
        for (int i : ids) {
            buf.func_150787_b(i);
            SyncedDataKey<?> key = SyncedDataManager.byId(i);
            CompoundNBT tag = new CompoundNBT();
            this.writeWithCodec(key).ifPresent(data -> tag.func_218657_a("a", (INBT)data));
            buf.func_150786_a(tag);
        }
    }

    public void applySyncPacket(PacketBuffer buf) {
        int size = buf.func_150792_a();
        for (int i = 0; i < size; ++i) {
            SyncedDataKey<?> key = SyncedDataManager.byId(buf.func_150792_a());
            CompoundNBT tag = buf.func_150793_b();
            if (tag != null && tag.func_74764_b("a")) {
                this.values.put(key, this.readWithCodec(key, tag.func_74781_a("a")));
            }
            buf.func_150786_a(tag);
        }
    }

    protected <T> T readWithCodec(SyncedDataKey<T> key, INBT data) {
        DataResult dataResult = key.getCodec().parse((DynamicOps)NBTDynamicOps.field_210820_a, (Object)data);
        if (dataResult.error().isPresent() || !dataResult.result().isPresent()) {
            LOGGER.error("Failed to decode " + key.getKey() + " from NBT: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + data);
            return key.getDefaultValueSupplier().get();
        }
        return dataResult.result().get();
    }

    protected <T> Optional<INBT> writeWithCodec(SyncedDataKey<T> key) {
        if (!this.values.containsKey(key)) {
            return Optional.empty();
        }
        T value = this.getValue(key);
        DataResult dataResult = key.getCodec().encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, value);
        if (dataResult.error().isPresent() || !dataResult.result().isPresent()) {
            LOGGER.error("Failed to encode " + key.getKey() + " to NBT: " + ((DataResult.PartialResult)dataResult.error().get()).message() + " " + value);
            return Optional.empty();
        }
        return dataResult.result();
    }

    public static enum NbtWriteMode {
        COPY,
        SAVE,
        RESPAWN;

    }
}

