/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.sync.forge;

import gg.moonflower.pollen.api.sync.DataComponent;
import gg.moonflower.pollen.api.sync.SyncedDataKey;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import gg.moonflower.pollen.api.sync.forge.ForgeDataComponent;
import gg.moonflower.pollen.core.network.PollenMessages;
import gg.moonflower.pollen.core.network.forge.ClientboundUpdateSyncedDataPacket;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="pollen")
@ApiStatus.Internal
public class SyncedDataManagerImpl {
    @CapabilityInject(value=ForgeDataComponent.class)
    public static final Capability<ForgeDataComponent> CAPABILITY = null;

    private static LazyOptional<ForgeDataComponent> getDataComponent(Entity entity) {
        return entity.getCapability(CAPABILITY);
    }

    public static void init() {
        CapabilityManager.INSTANCE.register(ForgeDataComponent.class, (Capability.IStorage)new Capability.IStorage<ForgeDataComponent>(){

            public INBT writeNBT(Capability<ForgeDataComponent> capability, ForgeDataComponent component, Direction direction) {
                CompoundNBT tag = new CompoundNBT();
                component.writeToNbt(tag, DataComponent.NbtWriteMode.SAVE);
                return tag;
            }

            public void readNBT(Capability<ForgeDataComponent> capability, ForgeDataComponent component, Direction direction, INBT tag) {
                component.readFromNbt((CompoundNBT)tag);
            }
        }, ForgeDataComponent::new);
    }

    @SubscribeEvent
    public static void onEvent(AttachCapabilitiesEvent<Entity> event) {
        event.addCapability(new ResourceLocation("pollen", "synced_data"), (ICapabilityProvider)new Provider());
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            Entity target = event.getTarget();
            SyncedDataManagerImpl.getDataComponent((Entity)player).ifPresent(component -> {
                if (component.shouldSyncWith(target, (Entity)player)) {
                    PollenMessages.PLAY.sendTo(player, new ClientboundUpdateSyncedDataPacket(target, (Entity)player, true));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)event.getEntity();
            SyncedDataManagerImpl.getDataComponent((Entity)player).ifPresent(component -> {
                if (component.shouldSyncWith((Entity)player, (Entity)player)) {
                    PollenMessages.PLAY.sendTo(player, new ClientboundUpdateSyncedDataPacket((Entity)player, (Entity)player, true));
                }
            });
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        if (event.getOriginal() instanceof ServerPlayerEntity && event.getPlayer() instanceof ServerPlayerEntity) {
            ServerPlayerEntity original = (ServerPlayerEntity)event.getOriginal();
            ServerPlayerEntity player = (ServerPlayerEntity)event.getPlayer();
            Optional originalOptional = SyncedDataManagerImpl.getDataComponent((Entity)original).resolve();
            Optional copyOptional = SyncedDataManagerImpl.getDataComponent((Entity)original).resolve();
            if (!originalOptional.isPresent() || !copyOptional.isPresent()) {
                return;
            }
            ForgeDataComponent oldHolder = (ForgeDataComponent)originalOptional.get();
            ForgeDataComponent newHolder = (ForgeDataComponent)copyOptional.get();
            if (oldHolder.shouldCopyForRespawn(!event.isWasDeath(), player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c))) {
                newHolder.copyForRespawn(oldHolder, !event.isWasDeath());
            }
            if (newHolder.shouldSyncWith((Entity)player, (Entity)player)) {
                PollenMessages.PLAY.sendTo(player, new ClientboundUpdateSyncedDataPacket((Entity)player, (Entity)player, true));
            }
        }
    }

    public static void sync(Entity entity) {
        SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> {
            if (component.isDirty()) {
                for (ServerPlayerEntity other : ((ServerWorld)entity.field_70170_p).func_73046_m().func_184103_al().func_181057_v()) {
                    if (!component.shouldSyncWith(entity, (Entity)other)) continue;
                    PollenMessages.PLAY.sendTo(other, new ClientboundUpdateSyncedDataPacket(entity, (Entity)other, false));
                }
                component.clean();
            }
        });
    }

    public static <T> void set(Entity entity, SyncedDataKey<T> key, T value) {
        SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> {
            SyncedDataManager.markDirty();
            component.setValue(key, value);
        });
    }

    public static <T> T get(Entity entity, SyncedDataKey<T> key) {
        LazyOptional<ForgeDataComponent> optional = SyncedDataManagerImpl.getDataComponent(entity);
        return optional.isPresent() ? ((ForgeDataComponent)optional.orElseThrow(() -> new IllegalStateException("Component should be present"))).getValue(key) : key.getDefaultValueSupplier().get();
    }

    public static void writePacketData(PacketBuffer buf, Entity provider, Entity entity, boolean sync) {
        if (sync) {
            SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> component.writeSyncPacket(buf, provider, entity));
        } else {
            SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> component.writeUpdatePacket(buf, provider, entity));
        }
    }

    public static void readPacketData(PacketBuffer buf, Entity entity) {
        SyncedDataManagerImpl.getDataComponent(entity).ifPresent(component -> component.applySyncPacket(buf));
    }

    public static class Provider
    implements ICapabilitySerializable<CompoundNBT> {
        private final ForgeDataComponent component = new ForgeDataComponent();
        private final LazyOptional<ForgeDataComponent> optional = LazyOptional.of(() -> this.component);

        public CompoundNBT serializeNBT() {
            CompoundNBT tag = new CompoundNBT();
            this.component.writeToNbt(tag, DataComponent.NbtWriteMode.SAVE);
            return tag;
        }

        public void deserializeNBT(CompoundNBT tag) {
            this.component.readFromNbt(tag);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
            return CAPABILITY.orEmpty(capability, this.optional);
        }
    }
}

