/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.api.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;

public class QuickMoveHelper {
    private final List<Action> actions = new ArrayList<Action>();

    private static boolean mergeItemStack(Container menu, ItemStack stack, int startIndex, int endIndex, boolean reverse) {
        boolean flag = false;
        int i = startIndex;
        if (reverse) {
            i = endIndex - 1;
        }
        if (stack.func_77985_e()) {
            while (!stack.func_190926_b() && !(reverse ? i < startIndex : i >= endIndex)) {
                Slot slot = menu.func_75139_a(i);
                ItemStack itemstack = slot.func_75211_c();
                if (slot.func_75214_a(stack) && !itemstack.func_190926_b() && Container.func_195929_a((ItemStack)stack, (ItemStack)itemstack)) {
                    int maxSize;
                    int j = itemstack.func_190916_E() + stack.func_190916_E();
                    if (j <= (maxSize = Math.min(slot.func_178170_b(stack), stack.func_77976_d()))) {
                        stack.func_190920_e(0);
                        itemstack.func_190920_e(j);
                        slot.func_75218_e();
                        flag = true;
                    } else if (itemstack.func_190916_E() < maxSize) {
                        stack.func_190918_g(maxSize - itemstack.func_190916_E());
                        itemstack.func_190920_e(maxSize);
                        slot.func_75218_e();
                        flag = true;
                    }
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!stack.func_190926_b()) {
            i = reverse ? endIndex - 1 : startIndex;
            while (!(!reverse ? i >= endIndex : i < startIndex)) {
                Slot slot1 = menu.func_75139_a(i);
                ItemStack itemstack1 = slot1.func_75211_c();
                if (itemstack1.func_190926_b() && slot1.func_75214_a(stack)) {
                    if (stack.func_190916_E() > slot1.func_178170_b(stack)) {
                        slot1.func_75215_d(stack.func_77979_a(slot1.func_178170_b(stack)));
                    } else {
                        slot1.func_75215_d(stack.func_77979_a(stack.func_190916_E()));
                    }
                    slot1.func_75218_e();
                    flag = true;
                    break;
                }
                if (reverse) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public QuickMoveHelper add(int fromStart, int fromSize, int toStart, int toSize, boolean reverse) {
        this.actions.add(new Action(fromStart, fromSize, toStart, toSize, reverse));
        return this;
    }

    public ItemStack quickMoveStack(Container menu, PlayerEntity player, int slotId) {
        ItemStack oldStack = ItemStack.field_190927_a;
        Slot slot = menu.func_75139_a(slotId);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotItem = slot.func_75211_c();
            oldStack = slotItem.func_77946_l();
            for (Action action : this.actions) {
                if (slotId < action.fromStart || slotId >= action.fromEnd || QuickMoveHelper.mergeItemStack(menu, slotItem, action.toStart, action.toEnd, action.reverse)) continue;
                return ItemStack.field_190927_a;
            }
            if (slotItem.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotItem.func_190916_E() == oldStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slotItem);
        }
        return oldStack;
    }

    public static class Action {
        private final int fromStart;
        private final int fromEnd;
        private final int toStart;
        private final int toEnd;
        private final boolean reverse;

        public Action(int fromStart, int fromSize, int toStart, int toSize, boolean reverse) {
            this.fromStart = fromStart;
            this.fromEnd = fromStart + fromSize;
            this.toStart = toStart;
            this.toEnd = toStart + toSize;
            this.reverse = reverse;
        }
    }
}

