/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core;

import com.google.common.base.Stopwatch;
import gg.moonflower.pollen.api.client.util.TextureDownloader;
import gg.moonflower.pollen.api.event.events.client.InputEvents;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.profile.ProfileManager;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimationManager;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModelManager;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryTextureManager;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class DebugInputs {
    static void init() {
        InputEvents.KEY_INPUT_EVENT.register(DebugInputs::onKeyInput);
    }

    private static boolean onKeyInput(int key, int scanCode, int action, int modifiers) {
        if (Platform.isProduction() || Minecraft.func_71410_x().field_71462_r instanceof ChatScreen || action != 1) {
            return false;
        }
        if (key == 92) {
            ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
            if ((modifiers & 4) > 0) {
                if (player == null) {
                    return true;
                }
                Stopwatch timer = Stopwatch.createStarted();
                UUID id = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
                ProfileManager.clearCache(id);
                EntitlementManager.clearCache();
                CompletableFuture.allOf(new CompletableFuture[]{GeometryModelManager.reload(false), GeometryTextureManager.reload(false), AnimationManager.reload(false), EntitlementManager.reload(true, CompletableFuture::completedFuture, (Executor)Minecraft.func_71410_x()).thenCompose(__ -> EntitlementManager.getEntitlementsFuture(id))}).handle((u, t) -> {
                    timer.stop();
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new TranslationTextComponent("debug.prefix").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})).func_240702_b_(" Took " + timer + " to reload entitlements"));
                    return u;
                });
                return true;
            }
            try {
                Path outputFolder = Paths.get(Minecraft.func_71410_x().field_71412_D.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                for (int i = 0; i < 1024; ++i) {
                    if (!GL11C.glIsTexture((int)i)) continue;
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i));
                }
                Util.func_215079_b(result).thenRunAsync(() -> Util.func_110647_a().func_195641_a(outputFolder.toFile()), (Executor)Minecraft.func_71410_x());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }
}

