/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.loader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.core.client.entitlement.EntitlementManager;
import gg.moonflower.pollen.core.client.entitlement.ModelEntitlement;
import gg.moonflower.pollen.pinwheel.api.client.FileCache;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelParser;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CosmeticModelLoader
implements BackgroundLoader<Map<ResourceLocation, GeometryModel>> {
    private static final Logger LOGGER = LogManager.getLogger();

    private static CompletableFuture<JsonObject> loadModel(FileCache cache, String modelUrl) {
        return cache.requestResource(modelUrl, false).thenApply(path -> {
            JsonObject jsonObject;
            if (path == null) {
                if (!Platform.isProduction()) {
                    LOGGER.warn("Cosmetic model at '" + modelUrl + "' could not be found");
                }
                return null;
            }
            InputStreamReader reader = new InputStreamReader(new FileInputStream(path.toFile()));
            try {
                jsonObject = new JsonParser().parse((Reader)reader).getAsJsonObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load cosmetic model from '" + modelUrl + "'", (Throwable)e);
                    return null;
                }
            }
            reader.close();
            return jsonObject;
        });
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, GeometryModel>> reload(IResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        ExecutorService executor = FileCache.createOnlineWorker();
        FileCache cache = FileCache.timed(executor, 1L, TimeUnit.DAYS);
        ConcurrentHashMap models = new ConcurrentHashMap();
        return CompletableFuture.allOf((CompletableFuture[])EntitlementManager.getAllEntitlements().filter(entitlement -> entitlement instanceof ModelEntitlement).flatMap(entitlement -> Arrays.stream(((ModelEntitlement)((Object)entitlement)).getModelUrls())).distinct().map(url -> CosmeticModelLoader.loadModel(cache, url).thenAcceptAsync(json -> {
            if (json == null) {
                return;
            }
            try {
                for (GeometryModelData model : GeometryModelParser.parseModel((JsonElement)json)) {
                    ResourceLocation id = new ResourceLocation("pollen", model.getDescription().getIdentifier());
                    if (models.put(id, GeometryModel.create(model)) == null) continue;
                    LOGGER.warn("Duplicate geometry model with id: " + id);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to parse cosmetic model: " + json, (Throwable)e);
            }
        }, gameExecutor)).toArray(CompletableFuture[]::new)).thenApplyAsync(__ -> {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Took more than 10 seconds to terminate online worker");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to terminate online worker", (Throwable)e);
            }
            return models;
        }, gameExecutor);
    }
}

