/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.profile;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import gg.moonflower.pollen.api.util.PollinatedModContainer;
import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import gg.moonflower.pollen.core.client.profile.ProfileData;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.util.HTTPUtil;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Session;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ProfileConnection {
    private static final String USER_AGENT = "Pollen/" + PollinatedModContainer.get("pollen").orElseThrow(() -> new IllegalStateException("No Pollen? wtf")).getVersion() + "/" + SharedConstants.func_215069_a().getName();
    private static final int MAX_AUTH_ATTEMPTS = 2;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new Gson();
    private final String apiUrl;
    private final String linkUrl;
    private final CompletableFuture<?> serverDown;
    private String token;

    public ProfileConnection(String apiUrl, String linkUrl) {
        this.apiUrl = apiUrl;
        this.linkUrl = linkUrl;
        this.serverDown = CompletableFuture.runAsync(() -> {
            try {
                HttpHead head = new HttpHead(apiUrl);
                try (CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();){
                    CloseableHttpResponse response = client.execute((HttpUriRequest)head);
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)HTTPUtil.field_180193_a);
    }

    @Nullable
    private static JsonElement getJsonResponse(HttpEntity entity) {
        if (entity.getContentType() != null && ContentType.APPLICATION_JSON.toString().equals(entity.getContentType().getValue())) {
            JsonElement jsonElement;
            InputStreamReader reader = new InputStreamReader(entity.getContent());
            try {
                jsonElement = new JsonParser().parse((Reader)reader);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
            reader.close();
            return jsonElement;
        }
        return null;
    }

    @Nullable
    private static Entitlement parseEntitlement(JsonObject json) throws JsonSyntaxException {
        String id = JSONUtils.func_151200_h((JsonObject)json, (String)"_id");
        JsonObject entitlementJson = JSONUtils.func_152754_s((JsonObject)json, (String)"entitlement");
        String displayName = JSONUtils.func_151219_a((JsonObject)entitlementJson, (String)"displayName", (String)id);
        Entitlement.Type type = Entitlement.Type.byName(JSONUtils.func_151200_h((JsonObject)entitlementJson, (String)"type"));
        if (type == null) {
            return null;
        }
        DataResult result = type.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)entitlementJson);
        if (result.error().isPresent()) {
            throw new JsonSyntaxException("Failed to parse '" + id + "'. " + ((DataResult.PartialResult)result.error().get()).message());
        }
        Entitlement entitlement = (Entitlement)result.result().orElseThrow(() -> new IllegalStateException("Failed to retrieve entitlement result"));
        entitlement.setRegistryName(id);
        entitlement.setDisplayName((ITextComponent)new StringTextComponent(displayName));
        return entitlement;
    }

    private static JsonElement checkError(String url, HttpResponse response) throws IOException {
        StatusLine statusLine = response.getStatusLine();
        JsonElement json = ProfileConnection.getJsonResponse(response.getEntity());
        if (statusLine.getStatusCode() != 200 || json == null) {
            if (json != null) {
                throw new IOException("Failed to connect to '" + url + "'. " + json.getAsJsonObject().get("status").getAsString() + " " + json.getAsJsonObject().get("error").getAsString());
            }
            throw new IOException("Failed to connect to '" + url + "'. " + statusLine.getStatusCode() + " " + statusLine.getReasonPhrase());
        }
        return json;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static JsonElement getProfileJson(String url) throws IOException, ProfileNotFoundException {
        HttpGet get = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();){
            JsonElement jsonElement;
            block16: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                try {
                    if (response.getStatusLine().getStatusCode() == 404) {
                        throw new ProfileNotFoundException();
                    }
                    jsonElement = ProfileConnection.checkError(url, (HttpResponse)response);
                    if (response == null) break block16;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonElement;
        }
        catch (ProfileNotFoundException | IOException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new IOException(t);
        }
    }

    private static JsonElement getJson(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();){
            JsonElement jsonElement;
            block12: {
                CloseableHttpResponse response = client.execute((HttpUriRequest)get);
                try {
                    jsonElement = ProfileConnection.checkError(url, (HttpResponse)response);
                    if (response == null) break block12;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return jsonElement;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getBearerToken() throws IOException {
        if (this.token == null) {
            String url = this.apiUrl + "/auth/minecraft";
            String secret = DigestUtils.sha1Hex((String)url);
            Session user = Minecraft.func_71410_x().func_110432_I();
            try {
                Minecraft.func_71410_x().func_152347_ac().joinServer(user.func_148256_e(), user.func_148254_d(), secret);
                HttpPost post = new HttpPost(url);
                post.setEntity(EntityBuilder.create().setText("{\"uuid\":\"" + user.func_148256_e().getId() + "\",\"username\":\"" + user.func_148256_e().getName() + "\",\"secret\":\"" + secret + "\"}").setContentType(ContentType.APPLICATION_JSON).build());
                try (CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();){
                    String string;
                    block16: {
                        CloseableHttpResponse response = client.execute((HttpUriRequest)post);
                        try {
                            string = this.token = JSONUtils.func_151200_h((JsonObject)ProfileConnection.checkError(url, (HttpResponse)response).getAsJsonObject(), (String)"token");
                            if (response == null) break block16;
                        }
                        catch (Throwable throwable) {
                            if (response != null) {
                                try {
                                    response.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        response.close();
                    }
                    return string;
                }
            }
            catch (IOException e) {
                this.token = null;
                throw e;
            }
            catch (Exception e) {
                this.token = null;
                throw new IOException(e);
            }
        }
        return this.token;
    }

    private <T> T runAuthenticated(AuthRequest<T> request) throws IOException {
        AtomicReference result = new AtomicReference();
        AuthRequestContext context = new AuthRequestContext(result::set);
        while (result.get() == null && context.attempt < 2) {
            request.run(context);
        }
        return (T)result.get();
    }

    private void checkConnection() throws IOException {
        try {
            this.serverDown.join();
        }
        catch (Exception e) {
            Throwable cause;
            if (e instanceof CompletionException && (cause = e.getCause()) instanceof IOException) {
                throw (IOException)cause;
            }
            throw new IOException("Failed to connect to server", e);
        }
    }

    public CompletableFuture<Boolean> isServerDown() {
        if (this.serverDown.isCompletedExceptionally()) {
            return CompletableFuture.completedFuture(true);
        }
        return this.serverDown.handle((__, e) -> e != null);
    }

    public ProfileData getProfileData(UUID profileId) throws IOException, ProfileNotFoundException {
        this.checkConnection();
        return (ProfileData)GSON.fromJson((JsonElement)ProfileConnection.getProfileJson(this.apiUrl + "/user/minecraft/" + profileId).getAsJsonObject(), ProfileData.class);
    }

    public Map<String, Entitlement> getEntitlements() throws IOException, ProfileNotFoundException {
        this.checkConnection();
        try {
            JsonArray array = ProfileConnection.getProfileJson(this.apiUrl + "/entitlement").getAsJsonArray();
            HashMap<String, Entitlement> entitlementMap = new HashMap<String, Entitlement>();
            for (JsonElement element : array) {
                try {
                    Entitlement entitlement = ProfileConnection.parseEntitlement(element.getAsJsonObject());
                    if (entitlement == null) continue;
                    entitlementMap.put(entitlement.getRegistryName().func_110623_a(), entitlement);
                }
                catch (JsonParseException e) {
                    LOGGER.error("Failed to parse entitlement: " + element, (Throwable)e);
                }
            }
            return entitlementMap;
        }
        catch (JsonParseException e) {
            throw new IOException("Failed to parse entitlements", e);
        }
    }

    @Nullable
    public Entitlement getEntitlement(String entitlementId) throws IOException {
        this.checkConnection();
        try {
            return ProfileConnection.parseEntitlement(ProfileConnection.getJson(this.apiUrl + "/entitlement/" + entitlementId).getAsJsonObject());
        }
        catch (JsonParseException e) {
            throw new IOException("Failed to parse entitlement", e);
        }
    }

    public Map<String, JsonObject> getEntitlementSettings(UUID profileId) throws IOException, ProfileNotFoundException {
        this.checkConnection();
        try {
            JsonArray array = ProfileConnection.getProfileJson(this.apiUrl + "/user/minecraft/" + profileId + "/entitlements").getAsJsonArray();
            HashMap<String, JsonObject> entitlementMap = new HashMap<String, JsonObject>();
            for (JsonElement element : array) {
                try {
                    JsonObject settingsJson = element.getAsJsonObject();
                    String id = JSONUtils.func_151200_h((JsonObject)settingsJson, (String)"id");
                    settingsJson.remove("type");
                    settingsJson.remove("id");
                    entitlementMap.put(id, settingsJson);
                }
                catch (JsonParseException e) {
                    LOGGER.error("Failed to parse entitlement: " + element, (Throwable)e);
                }
            }
            return entitlementMap;
        }
        catch (JsonParseException e) {
            throw new IOException("Failed to parse entitlements", e);
        }
    }

    public JsonObject getSettings(UUID profileId, String entitlementId) throws IOException, ProfileNotFoundException {
        this.checkConnection();
        return ProfileConnection.getProfileJson(this.apiUrl + "/user/minecraft/" + profileId + "/entitlements/" + entitlementId).getAsJsonObject();
    }

    public JsonObject updateSettings(UUID profileId, String entitlementId, JsonObject newSettings) throws IOException, ProfileNotFoundException {
        this.checkConnection();
        return (JsonObject)this.runAuthenticated(context -> {
            String url = this.apiUrl + "/user/minecraft/" + profileId + "/entitlements/" + entitlementId;
            HttpPatch patch = new HttpPatch(url);
            patch.setHeader("Authorization", "Bearer " + this.getBearerToken());
            patch.setEntity(EntityBuilder.create().setText(GSON.toJson((JsonElement)newSettings)).setContentType(ContentType.APPLICATION_JSON).build());
            try (CloseableHttpClient client = HttpClients.custom().setUserAgent(USER_AGENT).build();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)patch);){
                StatusLine statusLine = response.getStatusLine();
                if (statusLine.getStatusCode() == 404) {
                    throw new ProfileNotFoundException();
                }
                if (statusLine.getStatusCode() == 401) {
                    context.retry();
                    return;
                }
                context.complete(ProfileConnection.checkError(url, (HttpResponse)response).getAsJsonObject());
            }
        });
    }

    public LinkStatus linkPatreon() throws IOException {
        this.checkConnection();
        this.token = null;
        return (LinkStatus)this.runAuthenticated(context -> {
            String url = this.linkUrl + "/minecraft?token=" + this.getBearerToken() + "&ref=minecraft";
            CompletableFuture connectFuture = new CompletableFuture();
            CompletableFuture responseFuture = new CompletableFuture();
            AtomicReference<ServerSocket> server = new AtomicReference<ServerSocket>();
            CompletableFuture.runAsync(() -> {
                try (ServerSocket serverSocket = new ServerSocket(8001);){
                    server.set(serverSocket);
                    connectFuture.complete(null);
                    try (Socket clientSocket = serverSocket.accept();
                         PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);){
                        out.println("HTTP/1.1 200 OK");
                        responseFuture.complete(null);
                    }
                }
                catch (Exception e) {
                    if (!connectFuture.isDone()) {
                        connectFuture.completeExceptionally(e);
                    }
                    responseFuture.completeExceptionally(e);
                }
                finally {
                    server.set(null);
                }
                if (!responseFuture.isDone()) {
                    responseFuture.completeExceptionally(new IOException("Unknown Cause"));
                }
            }, (Executor)HTTPUtil.field_180193_a);
            context.complete(new LinkStatus(url, connectFuture, responseFuture, server));
        });
    }

    private class AuthRequestContext<T> {
        private final Consumer<T> completeCallback;
        private int attempt;

        private AuthRequestContext(Consumer<T> completeCallback) {
            this.completeCallback = completeCallback;
            this.attempt = 0;
        }

        public void retry() {
            ProfileConnection.this.token = null;
            ++this.attempt;
        }

        public void complete(T value) {
            this.completeCallback.accept(value);
        }
    }

    private static interface AuthRequest<T> {
        public void run(AuthRequestContext<T> var1) throws IOException;
    }

    public static class LinkStatus {
        private final String url;
        private final CompletableFuture<?> connectFuture;
        private final CompletableFuture<?> responseFuture;
        private final AtomicReference<ServerSocket> server;

        public LinkStatus(String url, CompletableFuture<?> connectFuture, CompletableFuture<?> responseFuture, AtomicReference<ServerSocket> server) {
            this.url = url;
            this.connectFuture = connectFuture;
            this.responseFuture = responseFuture;
            this.server = server;
        }

        public synchronized void cancel() {
            ServerSocket serverSocket = this.server.get();
            if (serverSocket == null) {
                return;
            }
            try {
                serverSocket.close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to cancel Patreon link", (Throwable)e);
                this.responseFuture.completeExceptionally(e);
            }
        }

        public String getUrl() {
            return this.url;
        }

        public CompletableFuture<?> getConnectFuture() {
            return this.connectFuture;
        }

        public CompletableFuture<?> getResponseFuture() {
            return this.responseFuture;
        }
    }
}

