/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.client.screen.button;

import gg.moonflower.pollen.core.client.entitlement.Entitlement;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class EntitlementEntry {
    private final ITextComponent caption;
    private final Entitlement entitlement;
    private List<IReorderingProcessor> toolTip;

    protected EntitlementEntry(ITextComponent caption, Entitlement entitlement) {
        this.caption = caption;
        this.entitlement = entitlement;
        this.toolTip = null;
    }

    public abstract Widget createButton(int var1, int var2, int var3);

    public abstract void updateButton(Widget var1);

    public abstract void save();

    protected Entitlement getEntitlement() {
        return this.entitlement;
    }

    protected ITextComponent getCaption() {
        return this.caption;
    }

    public void setTooltip(@Nullable List<IReorderingProcessor> toolTip) {
        this.toolTip = toolTip;
    }

    public Optional<List<IReorderingProcessor>> getTooltip() {
        return Optional.ofNullable(this.toolTip);
    }

    protected ITextComponent pixelValueLabel(int value) {
        return new TranslationTextComponent("options.pixel_value", new Object[]{this.getCaption(), value});
    }

    protected ITextComponent percentValueLabel(double percentage) {
        return new TranslationTextComponent("options.percent_value", new Object[]{this.getCaption(), (int)(percentage * 100.0)});
    }

    protected ITextComponent percentAddValueLabel(int doubleValue) {
        return new TranslationTextComponent("options.percent_add_value", new Object[]{this.getCaption(), doubleValue});
    }

    protected ITextComponent genericValueLabel(ITextComponent valueMessage) {
        return new TranslationTextComponent("options.generic_value", new Object[]{this.getCaption(), valueMessage});
    }

    protected ITextComponent genericValueLabel(int value) {
        return this.genericValueLabel((ITextComponent)new StringTextComponent(Integer.toString(value)));
    }
}

