/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge;

import gg.moonflower.pollen.api.event.events.client.render.AddRenderLayersEvent;
import gg.moonflower.pollen.api.event.events.client.render.InitRendererEvent;
import gg.moonflower.pollen.api.event.events.registry.client.ParticleFactoryRegistryEvent;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.sync.forge.SyncedDataManagerImpl;
import gg.moonflower.pollen.core.Pollen;
import gg.moonflower.pollen.core.mixin.forge.client.EntityRenderDispatcherAccessor;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod(value="pollen")
@ApiStatus.Internal
public class PollenForge {
    public PollenForge() {
        Pollen.PLATFORM.setup();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(PollenForge::init);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            modBus.addListener(EventPriority.NORMAL, true, ColorHandlerEvent.Block.class, event -> InitRendererEvent.EVENT.invoker().initRenderer());
            modBus.addListener(PollenForge::clientInit);
            modBus.addListener(PollenForge::registerParticles);
            modBus.addListener(PollenForge::registerSprites);
        });
    }

    private static void clientInit(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            EntityRendererManager entityRenderDispatcher = ((Minecraft)event.getMinecraftSupplier().get()).func_175598_ae();
            final Map<EntityType<?>, EntityRenderer<?>> renderers = ((EntityRenderDispatcherAccessor)entityRenderDispatcher).getRenderers();
            final Map<String, PlayerRenderer> playerRenderers = ((EntityRenderDispatcherAccessor)entityRenderDispatcher).getPlayerRenderers();
            AddRenderLayersEvent.EVENT.invoker().addLayers(new AddRenderLayersEvent.Context(){

                @Override
                public Set<String> getSkins() {
                    return playerRenderers.keySet();
                }

                @Override
                @Nullable
                public PlayerRenderer getSkin(String skinName) {
                    return (PlayerRenderer)playerRenderers.get(skinName);
                }

                @Override
                @Nullable
                public <T extends LivingEntity, R extends LivingRenderer<T, ? extends EntityModel<T>>> R getRenderer(EntityType<? extends T> entityType) {
                    return (R)((LivingRenderer)renderers.get(entityType));
                }
            });
        });
    }

    private static void init(FMLCommonSetupEvent event) {
        SyncedDataManagerImpl.init();
    }

    private static void registerSprites(TextureStitchEvent.Pre event) {
        AtlasTexture atlas = event.getMap();
        RegisterAtlasSpriteEvent.event(atlas.func_229223_g_()).invoker().registerSprites(atlas, arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
    }

    private static void registerParticles(ParticleFactoryRegisterEvent event) {
        final ParticleManager particleEngine = Minecraft.func_71410_x().field_71452_i;
        ParticleFactoryRegistryEvent.EVENT.invoker().registerParticles(new ParticleFactoryRegistryEvent.Registry(){

            @Override
            public <T extends IParticleData> void register(ParticleType<T> type, IParticleFactory<T> provider) {
                particleEngine.func_199283_a(type, provider);
            }

            @Override
            public <T extends IParticleData> void register(ParticleType<T> type, ParticleFactoryRegistryEvent.Factory<T> factory) {
                particleEngine.func_215234_a(type, factory::create);
            }
        });
    }
}

