/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge.compat.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.matrix.MatrixStack;
import gg.moonflower.pollen.api.crafting.grindstone.PollenGrindstoneRecipe;
import gg.moonflower.pollen.core.forge.compat.jei.PollenJeiPlugin;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredient;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class PollenGrindstoneCategory
implements IRecipeCategory<PollenGrindstoneRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final LoadingCache<PollenGrindstoneRecipe, DisplayData> cachedDisplayData;

    public PollenGrindstoneCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(new ResourceLocation("textures/gui/container/grindstone.png"), 30, 15, 116, 56).build();
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)Blocks.field_222427_lP));
        this.cachedDisplayData = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<PollenGrindstoneRecipe, DisplayData>(){

            public DisplayData load(PollenGrindstoneRecipe key) {
                return new DisplayData();
            }
        });
    }

    public ResourceLocation getUid() {
        return PollenJeiPlugin.GRINDSTONE_CATEGORY_ID;
    }

    public Class<? extends PollenGrindstoneRecipe> getRecipeClass() {
        return PollenGrindstoneRecipe.class;
    }

    @Deprecated
    public String getTitle() {
        return this.getTitleAsTextComponent().getString();
    }

    public ITextComponent getTitleAsTextComponent() {
        return Blocks.field_222427_lP.func_235333_g_();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(PollenGrindstoneRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, recipe.func_192400_c().stream().map(ingredient -> Arrays.asList(ingredient.func_193365_a())).collect(Collectors.toList()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, PollenGrindstoneRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 18, 3);
        guiItemStacks.init(1, true, 18, 24);
        guiItemStacks.init(2, false, 98, 18);
        guiItemStacks.set(ingredients);
        ((DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe)).currentIngredients = guiItemStacks.getGuiIngredients();
    }

    private static int getExperienceFromItem(ItemStack stack) {
        int i = 0;
        Map map = EnchantmentHelper.func_82781_a((ItemStack)stack);
        for (Map.Entry entry : map.entrySet()) {
            Enchantment enchantment = (Enchantment)entry.getKey();
            Integer integer = (Integer)entry.getValue();
            if (enchantment.func_190936_d()) continue;
            i += enchantment.func_77321_a(integer.intValue());
        }
        return i;
    }

    public void draw(PollenGrindstoneRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        int experience = recipe.getResultExperience();
        if (experience == -1) {
            DisplayData displayData = (DisplayData)this.cachedDisplayData.getUnchecked((Object)recipe);
            if (displayData.currentIngredients == null) {
                return;
            }
            ItemStack newTopStack = (ItemStack)((IGuiIngredient)displayData.currentIngredients.get(0)).getDisplayedIngredient();
            ItemStack newBottomStack = (ItemStack)((IGuiIngredient)displayData.currentIngredients.get(1)).getDisplayedIngredient();
            if (newBottomStack == null) {
                newBottomStack = ItemStack.field_190927_a;
            }
            if (newTopStack == null) {
                return;
            }
            experience = displayData.lastExperience;
            if (displayData.lastTopStack == null || displayData.lastBottomStack == null || !ItemStack.func_77989_b((ItemStack)displayData.lastBottomStack, (ItemStack)newBottomStack) || !ItemStack.func_77989_b((ItemStack)displayData.lastTopStack, (ItemStack)newTopStack)) {
                experience = PollenGrindstoneCategory.getExperienceFromItem(newTopStack) + PollenGrindstoneCategory.getExperienceFromItem(newBottomStack);
                displayData.setLast(newTopStack, newBottomStack, experience);
            }
        }
        if (experience > 0) {
            TranslationTextComponent experienceString = new TranslationTextComponent("gui.jei.category.pollen.grindstone.experience", new Object[]{(int)Math.ceil((double)experience / 2.0), experience});
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            font.func_243248_b(matrixStack, (ITextComponent)experienceString, (float)(this.background.getWidth() - font.func_238414_a_((ITextProperties)experienceString)), 0.0f, -8355712);
        }
    }

    public boolean isHandled(PollenGrindstoneRecipe recipe) {
        return !recipe.func_192399_d();
    }

    private static class DisplayData {
        @Nullable
        private Map<Integer, ? extends IGuiIngredient<ItemStack>> currentIngredients;
        @Nullable
        private ItemStack lastTopStack;
        @Nullable
        private ItemStack lastBottomStack;
        private int lastExperience;

        private DisplayData() {
        }

        public void setLast(ItemStack topStack, ItemStack bottomStack, int experience) {
            this.lastTopStack = topStack;
            this.lastBottomStack = bottomStack;
            this.lastExperience = experience;
        }
    }
}

