/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.forge.compat.jei;

import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.api.crafting.grindstone.PollenGrindstoneRecipe;
import gg.moonflower.pollen.api.crafting.grindstone.PollenShapelessGrindstoneRecipe;
import gg.moonflower.pollen.core.mixin.forge.client.RecipeManagerAccessor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class PollenRecipeMaker {
    private PollenRecipeMaker() {
    }

    public static List<PollenGrindstoneRecipe> getGrindstoneRecipes(IRecipeCategory<PollenGrindstoneRecipe> category, IIngredientManager ingredientManager) {
        List<PollenGrindstoneRecipe> recipes = PollenRecipeMaker.getRecipes(category, PollenRecipeTypes.GRINDSTONE_TYPE.get());
        Collection ingredients = ingredientManager.getAllIngredients(VanillaTypes.ITEM);
        Collection enchantments = ForgeRegistries.ENCHANTMENTS.getValues();
        for (ItemStack ingredient : ingredients) {
            ResourceLocation id;
            if (!ingredient.func_77956_u() || (id = ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)ingredient.func_77973_b())) == null) continue;
            Stream inputs = enchantments.stream().filter(enchantment -> !enchantment.func_190936_d()).flatMap(enchantment -> IntStream.rangeClosed(enchantment.func_77319_d(), enchantment.func_77325_b()).mapToObj(level -> {
                HashMap<Enchantment, Integer> enchantmentsMap = new HashMap<Enchantment, Integer>(1);
                enchantmentsMap.put((Enchantment)enchantment, level);
                ItemStack input = ingredient.func_77973_b() == Items.field_151122_aG ? new ItemStack((IItemProvider)Items.field_151134_bR) : ingredient.func_77946_l();
                EnchantmentHelper.func_82782_a(enchantmentsMap, (ItemStack)input);
                return input;
            }));
            recipes.add(new PollenShapelessGrindstoneRecipe(new ResourceLocation(id.func_110624_b(), "disenchant_" + id.func_110623_a()), "", ingredient, (NonNullList<Ingredient>)NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_234819_a_(inputs)}), -1));
        }
        return recipes;
    }

    public static <C extends IInventory, T extends IRecipe<C>> List<T> getRecipes(@Nullable IRecipeCategory<T> category, IRecipeType<T> type) {
        ClientPlayNetHandler connection = Minecraft.func_71410_x().func_147114_u();
        if (connection == null) {
            return Collections.emptyList();
        }
        return PollenRecipeMaker.getRecipes(connection.func_199526_e(), type).stream().filter(recipe -> !recipe.func_192399_d()).filter(recipe -> category == null || category.isHandled(recipe)).collect(Collectors.toList());
    }

    private static <C extends IInventory, T extends IRecipe<C>> Collection<T> getRecipes(RecipeManager recipeManager, IRecipeType<T> recipeType) {
        return ((RecipeManagerAccessor)recipeManager).invokeByType(recipeType).values();
    }
}

