/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin;

import gg.moonflower.pollen.api.crafting.PollenBrewingRecipe;
import gg.moonflower.pollen.api.crafting.PollenRecipeTypes;
import gg.moonflower.pollen.api.platform.Platform;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionBrewing;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PotionBrewing.class})
public class PotionBrewingMixin {
    @Unique
    private static List<PollenBrewingRecipe> getRecipes() {
        return Platform.getRecipeManager().map(recipeManager -> recipeManager.func_241447_a_(PollenRecipeTypes.BREWING_TYPE.get())).orElse(Collections.emptyList());
    }

    @Inject(method={"isPotionIngredient"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isPotionIngredient(ItemStack itemStack, CallbackInfoReturnable<Boolean> cir) {
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (!recipe.getIngredient().test(itemStack)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"isBrewablePotion"}, at={@At(value="HEAD")}, cancellable=true)
    private static void isBrewablePotion(Potion potion, CallbackInfoReturnable<Boolean> cir) {
        List<PollenBrewingRecipe> list = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipes : list) {
            if (recipes.getResult() != potion) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"hasPotionMix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void hasPotionMix(ItemStack potionStack, ItemStack ingredient, CallbackInfoReturnable<Boolean> cir) {
        Potion potion = PotionUtils.func_185191_c((ItemStack)potionStack);
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (recipe.getFrom() != potion || !recipe.getIngredient().test(ingredient)) continue;
            cir.setReturnValue((Object)true);
            return;
        }
    }

    @Inject(method={"mix"}, at={@At(value="HEAD")}, cancellable=true)
    private static void mix(ItemStack ingredient, ItemStack fromPotion, CallbackInfoReturnable<ItemStack> cir) {
        if (ingredient.func_190926_b()) {
            return;
        }
        Potion potion = PotionUtils.func_185191_c((ItemStack)fromPotion);
        List<PollenBrewingRecipe> recipes = PotionBrewingMixin.getRecipes();
        for (PollenBrewingRecipe recipe : recipes) {
            if (recipe.getFrom() != potion || !recipe.getIngredient().test(ingredient)) continue;
            cir.setReturnValue((Object)PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)fromPotion.func_77973_b()), (Potion)recipe.getResult()));
            return;
        }
    }
}

