/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.client;

import gg.moonflower.pollen.core.extensions.LevelRendererExtension;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererTicker;
import gg.moonflower.pollen.pinwheel.api.client.render.TickableBlockRenderer;
import gg.moonflower.pollen.pinwheel.core.client.DataContainerImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.ISpawnWorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientWorld.class})
public abstract class ClientLevelMixin
extends World
implements BlockRendererTicker {
    @Shadow
    @Final
    private Minecraft field_73037_M;
    @Unique
    private final Map<BlockPos, BlockState> pendingUpdates = new HashMap<BlockPos, BlockState>();
    @Unique
    private final Map<BlockPos, BlockState> updates = new HashMap<BlockPos, BlockState>();
    @Unique
    private final DataContainerImpl dataContainer = new DataContainerImpl((IBlockReader)((ClientWorld)this));

    private ClientLevelMixin(ISpawnWorldInfo writableLevelData, RegistryKey<World> resourceKey, DimensionType dimensionType, Supplier<IProfiler> supplier, boolean bl, boolean bl2, long l) {
        super(writableLevelData, resourceKey, dimensionType, supplier, bl, bl2, l);
    }

    @Override
    public void scheduleBlockRendererTick(BlockPos pos, BlockState state) {
        this.pendingUpdates.put(pos.func_185334_h(), state);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(BooleanSupplier hasTimeLeft, CallbackInfo ci) {
        this.updates.clear();
        this.updates.putAll(this.pendingUpdates);
        this.pendingUpdates.clear();
        ((LevelRendererExtension)this.field_73037_M.field_71438_f).pollen_getTickingBlockRenderers().forEach(pos -> {
            BlockState state = this.func_180495_p((BlockPos)pos);
            for (BlockRenderer renderer : BlockRendererRegistry.get(state.func_177230_c())) {
                if (!(renderer instanceof TickableBlockRenderer)) continue;
                BlockState oldState = this.updates.remove(pos);
                if (oldState != null) {
                    renderer.receiveUpdate(this, (BlockPos)pos, oldState, state, this.dataContainer.get((BlockPos)pos));
                }
                ((TickableBlockRenderer)renderer).tick(this, (BlockPos)pos, this.dataContainer.get((BlockPos)pos));
            }
        });
        this.updates.forEach((pos, state) -> {
            List<BlockRenderer> renderers = BlockRendererRegistry.get(state.func_177230_c());
            for (BlockRenderer renderer : renderers) {
                renderer.receiveUpdate(this, (BlockPos)pos, (BlockState)state, this.func_180495_p((BlockPos)pos), this.dataContainer.get((BlockPos)pos));
            }
        });
    }
}

