/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.mixin.client;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.pollen.api.fluid.PollinatedFluid;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.FluidBlockRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockDisplayReader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FluidBlockRenderer.class})
public class LiquidBlockRendererMixin {
    @Unique
    private final Map<Fluid, TextureAtlasSprite[]> customFluidSprites = new HashMap<Fluid, TextureAtlasSprite[]>();
    @Unique
    private final Map<FluidState, BlockState> fluidStateCache = new WeakHashMap<FluidState, BlockState>();
    @Unique
    private IBlockDisplayReader captureLevel;
    @Unique
    private FluidState captureFluid;
    @Unique
    private BlockPos capturePos;

    @Inject(method={"setupSprites"}, at={@At(value="TAIL")})
    public void setupSprites(CallbackInfo ci) {
        this.customFluidSprites.clear();
        this.fluidStateCache.clear();
        for (Fluid fluid : Registry.field_212619_h) {
            if (!(fluid instanceof PollinatedFluid)) continue;
            PollinatedFluid pollinatedFluid = (PollinatedFluid)fluid;
            Function atlas = Minecraft.func_71410_x().func_228015_a_(PlayerContainer.field_226615_c_);
            this.customFluidSprites.put(fluid, new TextureAtlasSprite[]{(TextureAtlasSprite)atlas.apply(pollinatedFluid.getStillTextureName()), (TextureAtlasSprite)atlas.apply(pollinatedFluid.getFlowingTextureName()), pollinatedFluid.getOverlayTextureName() != null ? (TextureAtlasSprite)atlas.apply(pollinatedFluid.getOverlayTextureName()) : null});
        }
    }

    @Inject(method={"tesselate"}, at={@At(value="HEAD")})
    public void captureFluid(IBlockDisplayReader lightReader, BlockPos pos, IVertexBuilder vertexBuilder, FluidState fluidState, CallbackInfoReturnable<Boolean> cir) {
        this.captureLevel = lightReader;
        this.captureFluid = fluidState;
        this.capturePos = pos;
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public boolean modifyIsLava(boolean value) {
        return value || this.customFluidSprites.containsKey(this.captureFluid.func_206886_c());
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public TextureAtlasSprite[] modifySprites(TextureAtlasSprite[] value) {
        return this.customFluidSprites.getOrDefault(this.captureFluid.func_206886_c(), value);
    }

    @ModifyVariable(method={"tesselate"}, at=@At(value="STORE"), ordinal=0)
    public int modifyColor(int value) {
        return this.customFluidSprites.containsKey(this.captureFluid.func_206886_c()) ? Minecraft.func_71410_x().func_184125_al().func_228054_a_(this.fluidStateCache.computeIfAbsent(this.captureFluid, FluidState::func_206883_i), this.captureLevel, this.capturePos, 0) : value;
    }
}

