/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.login;

import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.api.network.packet.login.SimplePollinatedLoginPacket;
import gg.moonflower.pollen.api.sync.SyncedDataManager;
import gg.moonflower.pollen.core.network.login.PollenClientLoginPacketHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ClientboundSyncPlayerDataKeysPacket
extends SimplePollinatedLoginPacket<PollenClientLoginPacketHandler> {
    private final Map<ResourceLocation, Integer> mappings;

    public ClientboundSyncPlayerDataKeysPacket() {
        this.mappings = SyncedDataManager.getIds().collect(Collectors.toMap(id -> SyncedDataManager.byId(id).getKey(), id -> id));
    }

    public ClientboundSyncPlayerDataKeysPacket(PacketBuffer buf) {
        int size = buf.func_150792_a();
        this.mappings = new HashMap<ResourceLocation, Integer>(size);
        for (int i = 0; i < size; ++i) {
            this.mappings.put(buf.func_192575_l(), buf.func_150792_a());
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) {
        buf.func_150787_b(this.mappings.size());
        for (Map.Entry<ResourceLocation, Integer> entry : this.mappings.entrySet()) {
            buf.func_192572_a(entry.getKey());
            buf.func_150787_b(entry.getValue().intValue());
        }
    }

    @Override
    public void processPacket(PollenClientLoginPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleSyncPlayerDataKeysPacket(this, ctx);
    }

    public Map<ResourceLocation, Integer> getMappings() {
        return this.mappings;
    }
}

