/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.core.network.play;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.network.packet.PollinatedPacketContext;
import gg.moonflower.pollen.core.network.play.PollenServerPlayPacketHandler;
import java.io.IOException;
import net.minecraft.network.PacketBuffer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class ServerboundUpdateSettingsPacket
implements PollinatedPacket<PollenServerPlayPacketHandler> {
    private final String entitlement;
    private final JsonObject settings;

    public ServerboundUpdateSettingsPacket(String entitlement, JsonObject settings) {
        this.entitlement = entitlement;
        this.settings = settings;
    }

    public ServerboundUpdateSettingsPacket(PacketBuffer buf) throws IOException {
        this.entitlement = buf.func_218666_n();
        try {
            this.settings = new JsonParser().parse(buf.func_218666_n()).getAsJsonObject();
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writePacketData(PacketBuffer buf) throws IOException {
        buf.func_180714_a(this.entitlement);
        buf.func_180714_a(this.settings.toString());
    }

    @Override
    public void processPacket(PollenServerPlayPacketHandler handler, PollinatedPacketContext ctx) {
        handler.handleUpdateSettingsPacket(this, ctx);
    }

    public String getEntitlement() {
        return this.entitlement;
    }

    public JsonObject getSettings() {
        return this.settings;
    }
}

