/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.molangcompiler.api;

import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.molangcompiler.core.node.MolangConstantNode;
import gg.moonflower.pollen.molangcompiler.core.node.MolangStaticNode;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;

public interface MolangExpression {
    public static final MolangExpression ZERO = MolangExpression.of(0.0f);

    public float resolve(MolangEnvironment var1) throws MolangException;

    default public float safeResolve(MolangEnvironment environment) {
        try {
            return this.resolve(environment);
        }
        catch (MolangException e) {
            e.printStackTrace();
            return 0.0f;
        }
    }

    public static MolangExpression of(float value) {
        return new MolangConstantNode(value);
    }

    public static MolangExpression of(boolean value) {
        return new MolangConstantNode(value ? 1.0f : 0.0f);
    }

    public static MolangExpression of(Supplier<Float> value) {
        return new MolangStaticNode(value);
    }

    public static MolangExpression of(BooleanSupplier value) {
        return new MolangStaticNode(() -> Float.valueOf(value.getAsBoolean() ? 1.0f : 0.0f));
    }
}

