/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.framebuffer;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.pollen.pinwheel.api.client.framebuffer.AdvancedFboAttachment;
import gg.moonflower.pollen.pinwheel.api.client.framebuffer.AdvancedFboRenderAttachment;
import gg.moonflower.pollen.pinwheel.api.client.framebuffer.AdvancedFboTextureAttachment;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.shader.Framebuffer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.NativeResource;

public class AdvancedFbo
implements NativeResource {
    private int id = -1;
    private int width;
    private int height;
    private final AdvancedFboAttachment[] colorAttachments;
    private final AdvancedFboAttachment depthAttachment;
    private final int clearMask;

    private AdvancedFbo(int width, int height, AdvancedFboAttachment[] colorAttachments, @Nullable AdvancedFboAttachment depthAttachment) {
        this.width = width;
        this.height = height;
        this.colorAttachments = colorAttachments;
        this.depthAttachment = depthAttachment;
        int mask = 0;
        if (this.hasColorAttachment(0)) {
            mask |= 0x4000;
        }
        if (this.hasDepthAttachment()) {
            mask |= 0x100;
        }
        this.clearMask = mask;
    }

    public void create() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::_create);
        } else {
            this._create();
        }
    }

    private void _create() {
        int status;
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.create();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.create();
        }
        this.id = GL30.glGenFramebuffers();
        this.bind(false);
        for (int i = 0; i < this.colorAttachments.length; ++i) {
            this.colorAttachments[i].attach(36160, i);
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.attach(36160, 0);
        }
        if ((status = GL30.glCheckFramebufferStatus((int)36160)) != 36053) {
            throw new IllegalStateException("Advanced FBO status did not return GL_FRAMEBUFFER_COMPLETE. 0x" + Integer.toHexString(status));
        }
        AdvancedFbo.unbind();
    }

    public void clear() {
        if (this.clearMask != 0) {
            GlStateManager.func_227658_a_((int)this.clearMask, (boolean)Minecraft.field_142025_a);
        }
    }

    public void bind(boolean setViewport) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this._bind(setViewport));
        } else {
            this._bind(setViewport);
        }
    }

    private void _bind(boolean setViewport) {
        GL30.glBindFramebuffer((int)36160, (int)this.id);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    public void bindRead() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36008, (int)this.id));
        } else {
            GL30.glBindFramebuffer((int)36008, (int)this.id);
        }
    }

    public void bindDraw(boolean setViewport) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this._bindDraw(this.id, setViewport));
        } else {
            this._bindDraw(this.id, setViewport);
        }
    }

    private void _bindDraw(int id, boolean setViewport) {
        GL30.glBindFramebuffer((int)36009, (int)id);
        if (setViewport) {
            RenderSystem.viewport((int)0, (int)0, (int)this.width, (int)this.height);
        }
    }

    public static void unbind() {
        Framebuffer mainTarget = Minecraft.func_71410_x().func_147110_a();
        if (mainTarget != null) {
            mainTarget.func_147610_a(true);
            return;
        }
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36160, (int)0));
        } else {
            GL30.glBindFramebuffer((int)36160, (int)0);
        }
    }

    public static void unbindRead() {
        int mainTarget;
        int n = mainTarget = Minecraft.func_71410_x().func_147110_a() != null ? Minecraft.func_71410_x().func_147110_a().field_147616_f : 0;
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36008, (int)mainTarget));
        } else {
            GL30.glBindFramebuffer((int)36008, (int)mainTarget);
        }
    }

    public static void unbindDraw() {
        int mainTarget;
        int n = mainTarget = Minecraft.func_71410_x().func_147110_a() != null ? Minecraft.func_71410_x().func_147110_a().field_147616_f : 0;
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindFramebuffer((int)36009, (int)mainTarget));
        } else {
            GL30.glBindFramebuffer((int)36009, (int)mainTarget);
        }
    }

    public void resolveToFbo(int id, int width, int height, int mask, int filtering) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this._resolveToFbo(id, width, height, mask, filtering));
        } else {
            this._resolveToFbo(id, width, height, mask, filtering);
        }
    }

    private void _resolveToFbo(int id, int width, int height, int mask, int filtering) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        this.bindRead();
        GL30.glBindFramebuffer((int)36009, (int)id);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)width, (int)height, (int)mask, (int)filtering);
        AdvancedFbo.unbind();
    }

    public void resolveToAdvancedFbo(AdvancedFbo target) {
        this.resolveToFbo(target.getId(), target.getWidth(), target.getHeight(), 16640, 9728);
    }

    public void resolveToAdvancedFbo(AdvancedFbo target, int mask, int filtering) {
        this.resolveToFbo(target.getId(), target.getWidth(), target.getHeight(), mask, filtering);
    }

    public void resolveToFramebuffer(Framebuffer target) {
        this.resolveToFbo(target.field_147616_f, target.field_147621_c, target.field_147618_d, 16640, 9728);
    }

    public void resolveToFramebuffer(Framebuffer target, int mask, int filtering) {
        this.resolveToFbo(target.field_147616_f, target.field_147621_c, target.field_147618_d, mask, filtering);
    }

    public void resolveToScreen() {
        this.resolveToScreen(16384, 9728);
    }

    public void resolveToScreen(int mask, int filtering) {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> this._resolveToScreen(mask, filtering));
        } else {
            this._resolveToScreen(mask, filtering);
        }
    }

    private void _resolveToScreen(int mask, int filtering) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        MainWindow window = Minecraft.func_71410_x().func_228018_at_();
        this.bindRead();
        AdvancedFbo.unbindDraw();
        GL30.glDrawBuffer((int)1029);
        GL30.glBlitFramebuffer((int)0, (int)0, (int)this.width, (int)this.height, (int)0, (int)0, (int)window.func_198109_k(), (int)window.func_198091_l(), (int)mask, (int)filtering);
        AdvancedFbo.unbindRead();
    }

    public void free() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(this::_free);
        } else {
            this._free();
        }
    }

    private void _free() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (this.id != -1) {
            GL30.glDeleteFramebuffers((int)this.id);
            this.id = -1;
        }
        for (AdvancedFboAttachment attachment : this.colorAttachments) {
            attachment.free();
        }
        if (this.depthAttachment != null) {
            this.depthAttachment.free();
        }
    }

    public int getId() {
        return this.id;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getColorAttachments() {
        return this.colorAttachments.length;
    }

    public boolean hasColorAttachment(int attachment) {
        return attachment >= 0 && attachment < this.colorAttachments.length;
    }

    public boolean hasDepthAttachment() {
        return this.depthAttachment != null;
    }

    public AdvancedFboAttachment getColorAttachment(int attachment) {
        Validate.isTrue((boolean)this.hasColorAttachment(attachment), (String)("Color attachment " + attachment + " does not exist."), (Object[])new Object[0]);
        return this.colorAttachments[attachment];
    }

    public boolean isColorTextureAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboTextureAttachment;
    }

    public boolean isColorRenderAttachment(int attachment) {
        return this.hasColorAttachment(attachment) && this.getColorAttachment(attachment) instanceof AdvancedFboRenderAttachment;
    }

    public AdvancedFboTextureAttachment getColorTextureAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorTextureAttachment(attachment), (String)("Color attachment " + attachment + " must be a texture attachment to modify texture information."), (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    public AdvancedFboRenderAttachment getColorRenderAttachment(int attachment) {
        AdvancedFboAttachment advancedFboAttachment = this.getColorAttachment(attachment);
        Validate.isTrue((boolean)this.isColorRenderAttachment(attachment), (String)("Color attachment " + attachment + " must be a render attachment to modify render information."), (Object[])new Object[0]);
        return (AdvancedFboRenderAttachment)advancedFboAttachment;
    }

    public AdvancedFboAttachment getDepthAttachment() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        Validate.isTrue((boolean)this.hasDepthAttachment(), (String)"Depth attachment does not exist.", (Object[])new Object[0]);
        return Objects.requireNonNull(this.depthAttachment);
    }

    public boolean isDepthTextureAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboTextureAttachment;
    }

    public boolean isDepthRenderAttachment() {
        return this.hasDepthAttachment() && this.getDepthAttachment() instanceof AdvancedFboRenderAttachment;
    }

    public AdvancedFboTextureAttachment getDepthTextureAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthTextureAttachment(), (String)"Depth attachment must be a texture attachment to modify texture information.", (Object[])new Object[0]);
        return (AdvancedFboTextureAttachment)advancedFboAttachment;
    }

    public AdvancedFboRenderAttachment getDepthRenderAttachment() {
        AdvancedFboAttachment advancedFboAttachment = this.getDepthAttachment();
        Validate.isTrue((boolean)this.isDepthRenderAttachment(), (String)"Depth attachment must be a render attachment to modify render information.", (Object[])new Object[0]);
        return (AdvancedFboRenderAttachment)advancedFboAttachment;
    }

    public Wrapper toRenderTarget() {
        return new Wrapper(this);
    }

    public static Builder withSize(int width, int height) {
        return new Builder(width, height);
    }

    public static Builder copy(AdvancedFbo parent) {
        return new Builder(parent.getWidth(), parent.getHeight()).addAttachments(parent);
    }

    public static Builder copy(Framebuffer parent) {
        if (parent instanceof Wrapper) {
            AdvancedFbo fbo = ((Wrapper)parent).getFbo();
            return new Builder(fbo.getWidth(), fbo.getHeight()).addAttachments(fbo);
        }
        return new Builder(parent.field_147622_a, parent.field_147620_b).addAttachments(parent);
    }

    public static class Wrapper
    extends Framebuffer {
        private final AdvancedFbo fbo;

        private Wrapper(AdvancedFbo fbo) {
            super(fbo.width, fbo.height, fbo.hasDepthAttachment(), Minecraft.field_142025_a);
            this.fbo = fbo;
            this.func_216492_b(this.fbo.getWidth(), this.fbo.getHeight(), Minecraft.field_142025_a);
        }

        public void func_216491_a(int width, int height, boolean onMac) {
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.func_216492_b(width, height, onMac));
            } else {
                this.func_216492_b(width, height, onMac);
            }
        }

        public void func_147608_a() {
            this.fbo.close();
        }

        public void func_216492_b(int width, int height, boolean onMac) {
            this.field_147621_c = width;
            this.field_147618_d = height;
            if (this.fbo == null) {
                return;
            }
            this.fbo.width = width;
            this.fbo.height = height;
            AdvancedFboAttachment attachment = this.fbo.hasColorAttachment(0) ? this.fbo.getColorAttachment(0) : null;
            this.field_147622_a = attachment == null ? this.field_147621_c : attachment.getWidth();
            this.field_147620_b = attachment == null ? this.field_147618_d : attachment.getHeight();
        }

        public void func_147607_a(int framebufferFilter) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            this.field_147623_j = framebufferFilter;
            for (int i = 0; i < this.fbo.getColorAttachments(); ++i) {
                this.fbo.getColorAttachment(i).bindAttachment();
                GlStateManager.func_227677_b_((int)3553, (int)10241, (int)framebufferFilter);
                GlStateManager.func_227677_b_((int)3553, (int)10240, (int)framebufferFilter);
                GlStateManager.func_227677_b_((int)3553, (int)10242, (int)10496);
                GlStateManager.func_227677_b_((int)3553, (int)10243, (int)10496);
                this.fbo.getColorAttachment(i).unbindAttachment();
            }
        }

        public void func_147612_c() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).bindAttachment();
            }
        }

        public void func_147606_d() {
            if (this.fbo.hasColorAttachment(0)) {
                this.fbo.getColorAttachment(0).unbindAttachment();
            }
        }

        public void func_147610_a(boolean setViewport) {
            this.fbo.bind(setViewport);
        }

        public AdvancedFbo getFbo() {
            return this.fbo;
        }
    }

    public static class Builder {
        private static final int MAX_COLOR_ATTACHMENTS = GL30.glGetInteger((int)36063);
        private final int width;
        private final int height;
        private final List<AdvancedFboAttachment> colorAttachments;
        private AdvancedFboAttachment depthAttachment;
        private int mipmaps;
        private int samples;
        private int format;

        private Builder(int width, int height) {
            this.width = width;
            this.height = height;
            this.colorAttachments = new LinkedList<AdvancedFboAttachment>();
            this.depthAttachment = null;
            this.mipmaps = 0;
            this.samples = 1;
            this.format = 6408;
        }

        private void validateColorSize() {
            Validate.inclusiveBetween((long)0L, (long)MAX_COLOR_ATTACHMENTS, (long)this.colorAttachments.size());
        }

        public Builder addAttachments(AdvancedFbo parent) {
            for (int i = 0; i < parent.getColorAttachments(); ++i) {
                this.colorAttachments.add(parent.getColorAttachment(i).createCopy());
            }
            this.validateColorSize();
            if (parent.hasDepthAttachment()) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.depthAttachment = parent.getDepthAttachment().createCopy();
            }
            return this;
        }

        public Builder addAttachments(Framebuffer parent) {
            this.setMipmaps(0);
            this.addColorTextureBuffer(parent.field_147622_a, parent.field_147620_b);
            if (parent.field_147619_e) {
                Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
                this.setSamples(1);
                this.setDepthRenderBuffer(parent.field_147622_a, parent.field_147620_b);
            }
            return this;
        }

        public Builder setMipmaps(int mipmaps) {
            this.mipmaps = mipmaps;
            return this;
        }

        public Builder setSamples(int samples) {
            this.samples = samples;
            return this;
        }

        public Builder setFormat(int format) {
            this.format = format;
            return this;
        }

        public Builder addColorTextureBuffer() {
            this.addColorTextureBuffer(this.width, this.height);
            return this;
        }

        public Builder addColorTextureBuffer(int width, int height) {
            this.colorAttachments.add(new AdvancedFboTextureAttachment(36064, this.format, width, height, this.mipmaps));
            this.validateColorSize();
            return this;
        }

        public Builder addColorRenderBuffer() {
            this.addColorRenderBuffer(this.width, this.height);
            return this;
        }

        public Builder addColorRenderBuffer(int width, int height) {
            this.colorAttachments.add(new AdvancedFboRenderAttachment(36064, this.format, width, height, this.samples));
            this.validateColorSize();
            return this;
        }

        public Builder setDepthTextureBuffer() {
            this.setDepthTextureBuffer(this.width, this.height);
            return this;
        }

        public Builder setDepthTextureBuffer(int width, int height) {
            Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
            this.depthAttachment = new AdvancedFboTextureAttachment(36096, this.format, width, height, this.mipmaps);
            return this;
        }

        public Builder setDepthRenderBuffer() {
            this.setDepthRenderBuffer(this.width, this.height);
            return this;
        }

        public Builder setDepthRenderBuffer(int width, int height) {
            Validate.isTrue((this.depthAttachment == null ? 1 : 0) != 0, (String)"Only one depth attachment can be applied to an FBO.", (Object[])new Object[0]);
            this.depthAttachment = new AdvancedFboRenderAttachment(36096, 33190, width, height, this.samples);
            return this;
        }

        public AdvancedFbo build(boolean create) {
            if (this.colorAttachments.isEmpty()) {
                throw new IllegalArgumentException("Framebuffer needs at least one color attachment to be complete.");
            }
            int samples = -1;
            for (AdvancedFboAttachment attachment : this.colorAttachments) {
                if (samples == -1) {
                    samples = attachment.getSamples();
                    continue;
                }
                if (attachment.getSamples() == samples) continue;
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
            if (this.depthAttachment != null && this.depthAttachment.getSamples() != samples) {
                throw new IllegalArgumentException("Framebuffer attachments need to have the same number of samples to be complete.");
            }
            AdvancedFbo advancedFbo = new AdvancedFbo(this.width, this.height, this.colorAttachments.toArray(new AdvancedFboAttachment[0]), this.depthAttachment);
            if (create) {
                advancedFbo.create();
            }
            return advancedFbo;
        }
    }
}

