/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.pollen.core.mixin.client.AgeableListModelAccessor;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BedrockGeometryModel;
import gg.moonflower.pollen.pinwheel.core.client.geometry.JavaModelConverter;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.AgeableModel;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import org.jetbrains.annotations.Nullable;

public interface GeometryModel {
    public static final GeometryModel EMPTY = new GeometryModel(){

        @Override
        public void render(String material, GeometryModelTexture texture, MatrixStack matrixStack, IVertexBuilder builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        }

        @Override
        public void resetTransformation() {
        }

        @Override
        public void copyAngles(@Nullable String parent, ModelRenderer modelPart) {
        }

        @Override
        public Optional<ModelRenderer> getModelPart(String part) {
            return Optional.empty();
        }

        @Override
        public ModelRenderer[] getChildRenderers(String part) {
            return new ModelRenderer[0];
        }

        @Override
        public ModelRenderer[] getModelParts() {
            return new ModelRenderer[0];
        }

        @Override
        public String[] getParentModelKeys() {
            return new String[0];
        }

        @Override
        public String[] getMaterialKeys() {
            return new String[0];
        }

        @Override
        public float getTextureWidth() {
            return 16.0f;
        }

        @Override
        public float getTextureHeight() {
            return 16.0f;
        }
    };

    public static GeometryModel create(GeometryModelData data) {
        return new BedrockGeometryModel(data.getDescription().getTextureWidth(), data.getDescription().getTextureHeight(), data.getBones());
    }

    public static GeometryModel create(int textureWidth, int textureHeight, GeometryModelData.Bone ... bones) {
        return new BedrockGeometryModel(textureWidth, textureHeight, bones);
    }

    public static GeometryModel create(int textureWidth, int textureHeight, ModelRenderer ... bones) {
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert(bones));
    }

    public static GeometryModel create(int textureWidth, int textureHeight, SegmentedModel<?> model) {
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert((ModelRenderer[])Iterables.toArray((Iterable)model.func_225601_a_(), ModelRenderer.class)));
    }

    public static GeometryModel create(int textureWidth, int textureHeight, AgeableModel<?> model) {
        AgeableListModelAccessor accessor = (AgeableListModelAccessor)model;
        return new BedrockGeometryModel(textureWidth, textureHeight, JavaModelConverter.convert((ModelRenderer[])Iterables.toArray((Iterable)Iterables.concat(accessor.invokeHeadParts(), accessor.invokeBodyParts()), ModelRenderer.class)));
    }

    public void render(String var1, GeometryModelTexture var2, MatrixStack var3, IVertexBuilder var4, int var5, int var6, float var7, float var8, float var9, float var10);

    public void resetTransformation();

    public void copyAngles(@Nullable String var1, ModelRenderer var2);

    public Optional<ModelRenderer> getModelPart(String var1);

    public ModelRenderer[] getChildRenderers(String var1);

    public ModelRenderer[] getModelParts();

    public String[] getParentModelKeys();

    public String[] getMaterialKeys();

    public float getTextureWidth();

    public float getTextureHeight();

    default public IVertexBuilder getBuffer(IRenderTypeBuffer buffer, GeometryAtlasTexture atlas, GeometryModelTexture texture, @Nullable Consumer<RenderType.State.Builder> renderTypeConsumer) {
        return atlas.getSprite(texture.getLocation()).func_229230_a_(buffer.getBuffer(texture.getLayer().getRenderType(texture, atlas, renderTypeConsumer)));
    }
}

