/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.geometry;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.entity.model.ArmorStandModel;
import net.minecraft.client.renderer.entity.model.BatModel;
import net.minecraft.client.renderer.entity.model.BeeModel;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.BlazeModel;
import net.minecraft.client.renderer.entity.model.BoarModel;
import net.minecraft.client.renderer.entity.model.BoatModel;
import net.minecraft.client.renderer.entity.model.BookModel;
import net.minecraft.client.renderer.entity.model.ChickenModel;
import net.minecraft.client.renderer.entity.model.CodModel;
import net.minecraft.client.renderer.entity.model.CreeperModel;
import net.minecraft.client.renderer.entity.model.DolphinModel;
import net.minecraft.client.renderer.entity.model.ElytraModel;
import net.minecraft.client.renderer.entity.model.EvokerFangsModel;
import net.minecraft.client.renderer.entity.model.FoxModel;
import net.minecraft.client.renderer.entity.model.GenericHeadModel;
import net.minecraft.client.renderer.entity.model.GuardianModel;
import net.minecraft.client.renderer.entity.model.HorseArmorChestsModel;
import net.minecraft.client.renderer.entity.model.HorseModel;
import net.minecraft.client.renderer.entity.model.HumanoidHeadModel;
import net.minecraft.client.renderer.entity.model.IllagerModel;
import net.minecraft.client.renderer.entity.model.IronGolemModel;
import net.minecraft.client.renderer.entity.model.LeashKnotModel;
import net.minecraft.client.renderer.entity.model.LlamaModel;
import net.minecraft.client.renderer.entity.model.LlamaSpitModel;
import net.minecraft.client.renderer.entity.model.MagmaCubeModel;
import net.minecraft.client.renderer.entity.model.OcelotModel;
import net.minecraft.client.renderer.entity.model.ParrotModel;
import net.minecraft.client.renderer.entity.model.PhantomModel;
import net.minecraft.client.renderer.entity.model.PiglinModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.entity.model.PufferFishBigModel;
import net.minecraft.client.renderer.entity.model.PufferFishMediumModel;
import net.minecraft.client.renderer.entity.model.PufferFishSmallModel;
import net.minecraft.client.renderer.entity.model.QuadrupedModel;
import net.minecraft.client.renderer.entity.model.RabbitModel;
import net.minecraft.client.renderer.entity.model.RavagerModel;
import net.minecraft.client.renderer.entity.model.SalmonModel;
import net.minecraft.client.renderer.entity.model.ShieldModel;
import net.minecraft.client.renderer.entity.model.ShulkerBulletModel;
import net.minecraft.client.renderer.entity.model.ShulkerModel;
import net.minecraft.client.renderer.entity.model.SlimeModel;
import net.minecraft.client.renderer.entity.model.SnowManModel;
import net.minecraft.client.renderer.entity.model.SpiderModel;
import net.minecraft.client.renderer.entity.model.SquidModel;
import net.minecraft.client.renderer.entity.model.StriderModel;
import net.minecraft.client.renderer.entity.model.TridentModel;
import net.minecraft.client.renderer.entity.model.TropicalFishAModel;
import net.minecraft.client.renderer.entity.model.TropicalFishBModel;
import net.minecraft.client.renderer.entity.model.TurtleModel;
import net.minecraft.client.renderer.entity.model.VexModel;
import net.minecraft.client.renderer.entity.model.VillagerModel;
import net.minecraft.client.renderer.entity.model.WitchModel;
import net.minecraft.client.renderer.entity.model.WolfModel;
import net.minecraft.client.renderer.entity.model.ZombieVillagerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.tileentity.model.DragonHeadModel;
import org.jetbrains.annotations.Nullable;

public final class VanillaModelMapping {
    private static final Map<Class<? extends Model>, Map<String, String>> MAPPING = new HashMap<Class<? extends Model>, Map<String, String>>();

    private VanillaModelMapping() {
    }

    private static void add(Class<? extends Model> clazz, String ... mapping) {
        ImmutableMap.Builder mappingBuilder = ImmutableMap.builder();
        Field[] fields = (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> !field.isSynthetic() && ModelRenderer.class.isAssignableFrom(field.getType())).toArray(Field[]::new);
        if (fields.length != mapping.length) {
            throw new IllegalStateException("Incorrect mapping configuration for " + clazz.getName() + ". Expected " + fields.length + " fields, got " + mapping.length);
        }
        for (int i = 0; i < fields.length; ++i) {
            mappingBuilder.put((Object)mapping[i], (Object)fields[i].getName());
        }
        if (MAPPING.put(clazz, (Map<String, String>)mappingBuilder.build()) != null) {
            throw new AssertionError((Object)("Duplicate mappings for " + clazz.getName()));
        }
    }

    private static String getInternal(Class<? extends Model> clazz, String name) {
        if (!MAPPING.containsKey(clazz)) {
            return null;
        }
        return MAPPING.get(clazz).get(name);
    }

    @Nullable
    public static String get(Class<? extends Model> clazz, String name) {
        Class<? extends Model> parent = clazz;
        while (Model.class.isAssignableFrom(parent)) {
            String field = VanillaModelMapping.getInternal(parent, name);
            if (field != null) {
                return field;
            }
            if (!Model.class.isAssignableFrom(parent.getSuperclass())) break;
            parent = parent.getSuperclass();
        }
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(name, name);
        MAPPING.put(clazz, fields);
        return name;
    }

    static {
        VanillaModelMapping.add(DragonHeadModel.class, "head", "jaw");
        VanillaModelMapping.add(ArmorStandModel.class, "bodyStick1", "bodyStick2", "shoulderStick", "basePlate");
        VanillaModelMapping.add(BatModel.class, "head", "body", "rightWing", "leftWing", "rightWingTip", "leftWingTip");
        VanillaModelMapping.add(BeeModel.class, "bone", "body", "rightWing", "leftWing", "frontLeg", "midLeg", "backLeg", "stinger", "leftAntenna", "rightAntenna");
        VanillaModelMapping.add(BlazeModel.class, "head");
        VanillaModelMapping.add(BoatModel.class, "waterPatch");
        VanillaModelMapping.add(BookModel.class, "leftLid", "rightLid", "leftPages", "rightPages", "flipPage1", "flipPage2", "seam");
        VanillaModelMapping.add(HorseArmorChestsModel.class, "boxL", "boxR");
        VanillaModelMapping.add(ChickenModel.class, "head", "body", "leg0", "leg1", "wing0", "wing1", "beak", "redThing");
        VanillaModelMapping.add(CodModel.class, "body", "topFin", "head", "nose", "sideFin0", "sideFin1", "tailFin");
        VanillaModelMapping.add(CreeperModel.class, "head", "hair", "body", "leg0", "leg1", "leg2", "leg3");
        VanillaModelMapping.add(DolphinModel.class, "body", "tail", "tailFin");
        VanillaModelMapping.add(ElytraModel.class, "rightWing", "leftWing");
        VanillaModelMapping.add(EvokerFangsModel.class, "base", "upperJaw", "lowerJaw");
        VanillaModelMapping.add(FoxModel.class, "head", "earL", "earR", "nose", "body", "leg0", "leg1", "leg2", "leg3", "tail");
        VanillaModelMapping.add(GuardianModel.class, "head", "eye");
        VanillaModelMapping.add(BoarModel.class, "head", "rightEar", "leftEar", "body", "frontRightLeg", "frontLeftLeg", "backRightLeg", "backLeftLeg", "mane");
        VanillaModelMapping.add(HorseModel.class, "body", "headParts", "leg1", "leg2", "leg3", "leg4", "babyLeg1", "babyLeg2", "babyLeg3", "babyLeg4", "tail");
        VanillaModelMapping.add(HumanoidHeadModel.class, "hat");
        VanillaModelMapping.add(BipedModel.class, "head", "hat", "body", "rightArm", "leftArm", "rightLeg", "leftLeg");
        VanillaModelMapping.add(IllagerModel.class, "head", "hat", "body", "arms", "leftLeg", "rightLeg", "rightArm", "leftArm");
        VanillaModelMapping.add(IronGolemModel.class, "head", "body", "arm0", "arm1", "leg0", "leg1");
        VanillaModelMapping.add(MagmaCubeModel.class, "insideCube");
        VanillaModelMapping.add(LeashKnotModel.class, "knot");
        VanillaModelMapping.add(LlamaModel.class, "head", "body", "leg0", "leg1", "leg2", "leg3", "chest1", "chest2");
        VanillaModelMapping.add(LlamaSpitModel.class, "main");
        VanillaModelMapping.add(OcelotModel.class, "backLegL", "backLegR", "frontLegL", "frontLegR", "tail1", "tail2", "head", "body");
        VanillaModelMapping.add(ParrotModel.class, "body", "tail", "wingLeft", "wingRight", "head", "head2", "beak1", "beak2", "feather", "legLeft", "legRight");
        VanillaModelMapping.add(PhantomModel.class, "body", "leftWingBase", "leftWingTip", "rightWingBase", "rightWingTip", "tailBase", "tailTip");
        VanillaModelMapping.add(PiglinModel.class, "earRight", "earLeft", "bodyDefault", "headDefault", "leftArmDefault", "rightArmDefault");
        VanillaModelMapping.add(PlayerModel.class, "leftSleeve", "rightSleeve", "leftPants", "rightPants", "jacket", "cloak", "ear");
        VanillaModelMapping.add(PufferFishBigModel.class, "cube", "blueFin0", "blueFin1", "topFrontFin", "topMidFin", "topBackFin", "sideFrontFin0", "sideFrontFin1", "bottomFrontFin", "bottomBackFin", "bottomMidFin", "sideBackFin0", "sideBackFin1");
        VanillaModelMapping.add(PufferFishMediumModel.class, "cube", "finBlue0", "finBlue1", "finTop0", "finTop1", "finSide0", "finSide1", "finSide2", "finSide3", "finBottom0", "finBottom1");
        VanillaModelMapping.add(PufferFishSmallModel.class, "cube", "eye0", "eye1", "fin0", "fin1", "finBack");
        VanillaModelMapping.add(QuadrupedModel.class, "head", "body", "leg0", "leg1", "leg2", "leg3");
        VanillaModelMapping.add(RabbitModel.class, "rearFootLeft", "rearFootRight", "haunchLeft", "haunchRight", "body", "frontLegLeft", "frontLegRight", "head", "earRight", "earLeft", "tail", "nose");
        VanillaModelMapping.add(RavagerModel.class, "head", "mouth", "body", "leg0", "leg1", "leg2", "leg3", "neck");
        VanillaModelMapping.add(SalmonModel.class, "bodyFront", "bodyBack", "head", "sideFin0", "sideFin1");
        VanillaModelMapping.add(ShieldModel.class, "plate", "handle");
        VanillaModelMapping.add(ShulkerBulletModel.class, "main");
        VanillaModelMapping.add(ShulkerModel.class, "base", "lid", "head");
        VanillaModelMapping.add(GenericHeadModel.class, "head");
        VanillaModelMapping.add(SlimeModel.class, "cube", "eye0", "eye1", "mouth");
        VanillaModelMapping.add(SnowManModel.class, "piece1", "piece2", "head", "arm1", "arm2");
        VanillaModelMapping.add(SpiderModel.class, "head", "body0", "body1", "leg0", "leg1", "leg2", "leg3", "leg4", "leg5", "leg6", "leg7");
        VanillaModelMapping.add(SquidModel.class, "body");
        VanillaModelMapping.add(StriderModel.class, "rightLeg", "leftLeg", "body", "bristle0", "bristle1", "bristle2", "bristle3", "bristle4", "bristle5");
        VanillaModelMapping.add(TridentModel.class, "pole");
        VanillaModelMapping.add(TropicalFishAModel.class, "body", "tail", "leftFin", "rightFin", "topFin");
        VanillaModelMapping.add(TropicalFishBModel.class, "body", "tail", "leftFin", "rightFin", "topFin", "bottomFin");
        VanillaModelMapping.add(TurtleModel.class, "eggBelly");
        VanillaModelMapping.add(VexModel.class, "leftWing", "rightWing");
        VanillaModelMapping.add(VillagerModel.class, "head", "hat", "hatRim", "body", "jacket", "arms", "leg0", "leg1", "nose");
        VanillaModelMapping.add(WitchModel.class, "mole");
        VanillaModelMapping.add(WolfModel.class, "head", "realHead", "body", "leg0", "leg1", "leg2", "leg3", "tail", "realTail", "upperBody");
        VanillaModelMapping.add(ZombieVillagerModel.class, "hatRim");
    }
}

