/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.render;

import com.mojang.blaze3d.matrix.MatrixStack;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRenderer;
import gg.moonflower.pollen.pinwheel.api.client.render.BlockRendererRegistry;
import gg.moonflower.pollen.pinwheel.core.client.DataContainerImpl;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;

public final class BlockRendererDispatcher {
    private static final Map<IBlockReader, DataContainerImpl> DATA_CONTAINERS = new WeakHashMap<IBlockReader, DataContainerImpl>(3);

    private BlockRendererDispatcher() {
    }

    public static void render(IWorldReader level, MatrixStack matrixStack, IRenderTypeBuffer buffer, ActiveRenderInfo camera, BlockState state, BlockPos pos, int packedLight, int packedOverlay, float partialTicks) {
        BlockRendererDispatcher.render(level, matrixStack, buffer, camera, BlockRendererRegistry.get(state.func_177230_c()), pos, packedLight, packedOverlay, partialTicks);
    }

    public static void render(IWorldReader level, MatrixStack matrixStack, IRenderTypeBuffer buffer, ActiveRenderInfo camera, List<BlockRenderer> renderers, BlockPos pos, int packedLight, int packedOverlay, float partialTicks) {
        GameRenderer gameRenderer = Minecraft.func_71410_x().field_71460_t;
        for (BlockRenderer renderer : renderers) {
            matrixStack.func_227860_a_();
            renderer.render(level, pos, BlockRendererDispatcher.getDataContainer((IBlockReader)level, pos), buffer, matrixStack, camera, gameRenderer, gameRenderer.func_228384_l_(), packedLight, packedOverlay, partialTicks);
            matrixStack.func_227865_b_();
        }
    }

    public static boolean shouldRender(BlockState state) {
        BlockRenderer renderer = BlockRendererRegistry.getFirst(state.func_177230_c());
        return renderer != null && renderer.getRenderShape(state) != BlockRenderType.MODEL;
    }

    public static BlockRenderer.DataContainer getDataContainer(IBlockReader level, BlockPos pos) {
        return DATA_CONTAINERS.computeIfAbsent(level, __ -> new DataContainerImpl(level)).get(pos);
    }
}

