/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.shader;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.nio.FloatBuffer;
import java.util.Map;
import java.util.OptionalInt;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector4f;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.system.NativeResource;

public class ShaderInstance
implements NativeResource {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final FloatBuffer MATRIX_4_4 = BufferUtils.createFloatBuffer((int)16);
    private final Map<CharSequence, Integer> uniforms;
    private int program;

    ShaderInstance(int program) {
        this.program = program;
        this.uniforms = new Object2IntArrayMap();
    }

    public static void unbind() {
        GL20C.glUseProgram((int)0);
    }

    public OptionalInt getUniform(CharSequence uniformName) {
        int uniform = this.uniforms.computeIfAbsent(uniformName, key -> {
            int location = GL20C.glGetUniformLocation((int)this.program, (CharSequence)uniformName);
            if (location == -1) {
                LOGGER.warn("Unknown uniform: " + uniformName);
            }
            return location;
        });
        return uniform == -1 ? OptionalInt.empty() : OptionalInt.of(uniform);
    }

    public void loadBoolean(CharSequence uniformName, boolean ... values) {
        int[] integers = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = values[i] ? 1 : 0;
        }
        this.loadInt(uniformName, integers);
    }

    public void loadVector2(CharSequence uniformName, boolean ... values) {
        int[] integers = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = values[i] ? 1 : 0;
        }
        this.loadVector2(uniformName, integers);
    }

    public void loadVector3(CharSequence uniformName, boolean ... values) {
        int[] integers = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = values[i] ? 1 : 0;
        }
        this.loadVector3(uniformName, integers);
    }

    public void loadVector4(CharSequence uniformName, boolean ... values) {
        int[] integers = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            integers[i] = values[i] ? 1 : 0;
        }
        this.loadVector4(uniformName, integers);
    }

    public void loadInt(CharSequence uniformName, int ... values) {
        if (values.length == 0) {
            return;
        }
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform1iv((int)uniform, (int[])values));
    }

    public void loadVector2(CharSequence uniformName, int ... values) {
        if (values.length == 0) {
            return;
        }
        Validate.isTrue((values.length % 2 == 0 ? 1 : 0) != 0);
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform2iv((int)uniform, (int[])values));
    }

    public void loadVector3(CharSequence uniformName, int ... values) {
        if (values.length == 0) {
            return;
        }
        Validate.isTrue((values.length % 3 == 0 ? 1 : 0) != 0);
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform3iv((int)uniform, (int[])values));
    }

    public void loadVector4(CharSequence uniformName, int ... values) {
        if (values.length == 0) {
            return;
        }
        Validate.isTrue((values.length % 4 == 0 ? 1 : 0) != 0);
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform4iv((int)uniform, (int[])values));
    }

    public void loadFloat(CharSequence uniformName, float ... values) {
        if (values.length == 0) {
            return;
        }
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform1fv((int)uniform, (float[])values));
    }

    public void loadVector2(CharSequence uniformName, float ... values) {
        if (values.length == 0) {
            return;
        }
        Validate.isTrue((values.length % 2 == 0 ? 1 : 0) != 0);
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform2fv((int)uniform, (float[])values));
    }

    public void loadVector3(CharSequence uniformName, float ... values) {
        if (values.length == 0) {
            return;
        }
        Validate.isTrue((values.length % 3 == 0 ? 1 : 0) != 0);
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform3fv((int)uniform, (float[])values));
    }

    public void loadVector4(CharSequence uniformName, float ... values) {
        if (values.length == 0) {
            return;
        }
        Validate.isTrue((values.length % 4 == 0 ? 1 : 0) != 0);
        this.getUniform(uniformName).ifPresent(uniform -> GL20C.glUniform4fv((int)uniform, (float[])values));
    }

    public void loadVector(CharSequence uniformName, Vector3f ... values) {
        float[] floats = new float[values.length * 3];
        for (int i = 0; i < values.length; ++i) {
            Vector3f value = values[i];
            floats[i * 3] = value.func_195899_a();
            floats[i * 3 + 1] = value.func_195900_b();
            floats[i * 3 + 2] = value.func_195902_c();
        }
        this.loadVector3(uniformName, floats);
    }

    public void loadVector(CharSequence uniformName, Vector4f ... values) {
        float[] floats = new float[values.length * 4];
        for (int i = 0; i < values.length; ++i) {
            Vector4f value = values[i];
            floats[i * 4] = value.func_195910_a();
            floats[i * 4 + 1] = value.func_195913_b();
            floats[i * 4 + 2] = value.func_195914_c();
            floats[i * 4 + 3] = value.func_195915_d();
        }
        this.loadVector4(uniformName, floats);
    }

    public void loadMatrix(CharSequence uniformName, Matrix4f matrix) {
        this.getUniform(uniformName).ifPresent(uniform -> {
            matrix.func_195879_b(MATRIX_4_4);
            GL20C.glUniformMatrix4fv((int)uniform, (boolean)false, (FloatBuffer)MATRIX_4_4);
        });
    }

    public void bind() {
        if (this.program <= 0) {
            return;
        }
        GL20C.glUseProgram((int)this.program);
    }

    public void free() {
        if (this.program == 0) {
            return;
        }
        if (this.program > 0) {
            GL20C.glDeleteProgram((int)this.program);
        }
        this.setProgram(0);
    }

    public int getProgram() {
        return this.program;
    }

    void setProgram(int program) {
        this.program = program;
        this.uniforms.clear();
    }
}

