/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.shader;

import com.google.gson.JsonParser;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.pinwheel.api.client.shader.ShaderException;
import gg.moonflower.pollen.pinwheel.api.client.shader.ShaderInstance;
import gg.moonflower.pollen.pinwheel.api.client.shader.ShaderPreProcessor;
import gg.moonflower.pollen.pinwheel.api.client.shader.ShaderProgram;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL20C;

public final class ShaderLoader {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ShaderPreProcessor> GLOBAL_PRE_PROCESSORS = new ArrayList<ShaderPreProcessor>(0);
    private static final Map<ResourceLocation, List<ShaderPreProcessor>> PRE_PROCESSORS = new HashMap<ResourceLocation, List<ShaderPreProcessor>>(0);
    private static final Map<ShaderProgram.Shader, Map<ResourceLocation, Integer>> SHADERS = new HashMap<ShaderProgram.Shader, Map<ResourceLocation, Integer>>();
    private static final Map<ResourceLocation, ShaderProgram> PROGRAMS = new HashMap<ResourceLocation, ShaderProgram>();
    private static final Map<ShaderInstance, ResourceLocation> INSTANCES = new HashMap<ShaderInstance, ResourceLocation>();

    private ShaderLoader() {
    }

    @ApiStatus.Internal
    public static void init() {
        ResourceRegistry.registerReloadListener(ResourcePackType.CLIENT_RESOURCES, new Reloader());
    }

    public static synchronized void addPreProcessor(ResourceLocation shader, ShaderPreProcessor processor) {
        PRE_PROCESSORS.computeIfAbsent(shader, key -> new ArrayList(1)).add(processor);
    }

    public static synchronized void addGlobalPreProcessor(ShaderPreProcessor processor) {
        GLOBAL_PRE_PROCESSORS.add(processor);
    }

    public static ShaderInstance create(ResourceLocation program) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        try {
            int programId = ShaderLoader.linkShaders(program, 0);
            ShaderInstance instance = new ShaderInstance(programId);
            INSTANCES.put(instance, program);
            return instance;
        }
        catch (Exception e) {
            LOGGER.error("Failed to create new shader instance: " + program, (Throwable)e);
            ShaderInstance instance = new ShaderInstance(-1);
            INSTANCES.put(instance, program);
            return instance;
        }
    }

    private static OptionalInt getShader(ShaderProgram.Shader type, ResourceLocation id) {
        if (!SHADERS.containsKey((Object)type)) {
            return OptionalInt.empty();
        }
        Map<ResourceLocation, Integer> map = SHADERS.get((Object)type);
        return map.containsKey(id) ? OptionalInt.of(map.get(id)) : OptionalInt.empty();
    }

    private static CharSequence preprocessShader(ResourceLocation id, String data, ShaderProgram.Shader type) {
        if (PRE_PROCESSORS.containsKey(id)) {
            for (ShaderPreProcessor processor : PRE_PROCESSORS.get(id)) {
                try {
                    data = processor.modify(id, data, type);
                }
                catch (Throwable t) {
                    LOGGER.error("Shader Pre-Processor threw an exception. Ignoring processing step.", t);
                }
            }
        }
        for (ShaderPreProcessor processor : GLOBAL_PRE_PROCESSORS) {
            try {
                data = processor.modify(id, data, type);
            }
            catch (Throwable t) {
                LOGGER.error("Shader Pre-Processor threw an exception. Ignoring processing step.", t);
            }
        }
        return data;
    }

    private static int loadShader(CharSequence data, ShaderProgram.Shader type) throws ShaderException {
        int shader = GL20C.glCreateShader((int)type.getGLType());
        GL20C.glShaderSource((int)shader, (CharSequence)data);
        GL20C.glCompileShader((int)shader);
        if (GL20C.glGetShaderi((int)shader, (int)35713) != 1) {
            throw new ShaderException(GL20C.glGetShaderInfoLog((int)shader, (int)512));
        }
        return shader;
    }

    private static int linkShaders(ResourceLocation program, int programId) throws ShaderException {
        if (!PROGRAMS.containsKey(program)) {
            throw new IllegalStateException("Unknown program: " + program);
        }
        ShaderProgram p = PROGRAMS.get(program);
        OptionalInt vertex = p.getVertexShader().map(shader -> ShaderLoader.getShader(ShaderProgram.Shader.VERTEX, shader)).orElse(OptionalInt.empty());
        OptionalInt fragment = p.getFragmentShader().map(shader -> ShaderLoader.getShader(ShaderProgram.Shader.FRAGMENT, shader)).orElse(OptionalInt.empty());
        OptionalInt geometry = p.getGeometryShader().map(shader -> ShaderLoader.getShader(ShaderProgram.Shader.GEOMETRY, shader)).orElse(OptionalInt.empty());
        OptionalInt[] compute = p.getComputeShaders().map(array -> (OptionalInt[])Stream.of(array).map(shader -> ShaderLoader.getShader(ShaderProgram.Shader.COMPUTE, shader)).toArray(OptionalInt[]::new)).orElseGet(() -> new OptionalInt[0]);
        if (compute.length > 0) {
            if (vertex.isPresent() || fragment.isPresent() || geometry.isPresent()) {
                throw new IllegalStateException("Compute shaders must only have compute steps");
            }
            if (Arrays.stream(compute).anyMatch(optional -> !optional.isPresent())) {
                throw new IllegalStateException("All compute shaders must be valid");
            }
        } else if (!vertex.isPresent() || !fragment.isPresent()) {
            throw new IllegalStateException("Both vertex and fragment shaders must be defined for a standard shader program");
        }
        if (programId > 0) {
            GL20C.glDeleteProgram((int)programId);
        }
        programId = GL20C.glCreateProgram();
        if (compute.length <= 0) {
            GL20C.glAttachShader((int)programId, (int)vertex.getAsInt());
            GL20C.glAttachShader((int)programId, (int)fragment.getAsInt());
            if (geometry.isPresent()) {
                GL20C.glAttachShader((int)programId, (int)geometry.getAsInt());
            }
        } else {
            for (OptionalInt shader2 : compute) {
                GL20C.glAttachShader((int)programId, (int)shader2.orElseThrow(() -> new IllegalStateException("All compute shaders must be valid")));
            }
        }
        GL20C.glLinkProgram((int)programId);
        if (GL20C.glGetProgrami((int)programId, (int)35714) != 1) {
            throw new ShaderException(GL20C.glGetProgramInfoLog((int)programId, (int)512));
        }
        return programId;
    }

    private static class Reloader
    implements PollinatedPreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            CompletableFuture<Map> sourcesFuture = CompletableFuture.supplyAsync(() -> {
                HashMap<ShaderProgram.Shader, Map> sources = new HashMap<ShaderProgram.Shader, Map>();
                for (ResourceLocation location : resourceManager.func_199003_a("shaders/program", path -> ShaderProgram.Shader.byExtension(path) != null)) {
                    ShaderProgram.Shader type = Objects.requireNonNull(ShaderProgram.Shader.byExtension(location.func_110623_a()));
                    ResourceLocation id = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring(16, location.func_110623_a().length() - type.getExtension().length()));
                    try {
                        IResource resource = resourceManager.func_199002_a(location);
                        try {
                            sources.computeIfAbsent(type, key -> new HashMap()).put(id, IOUtils.toString((InputStream)resource.func_199027_b(), (Charset)StandardCharsets.UTF_8));
                        }
                        finally {
                            if (resource == null) continue;
                            resource.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load shader: " + id, (Throwable)e);
                    }
                }
                return sources;
            }, backgroundExecutor);
            CompletableFuture<Map> programsFuture = CompletableFuture.supplyAsync(() -> {
                HashMap<ResourceLocation, ShaderProgram> sources = new HashMap<ResourceLocation, ShaderProgram>();
                for (ResourceLocation location : resourceManager.func_199003_a("shaders/program_type", path -> path.endsWith(".json"))) {
                    ResourceLocation id = new ResourceLocation(location.func_110624_b(), location.func_110623_a().substring(21, location.func_110623_a().length() - 5));
                    try {
                        IResource resource = resourceManager.func_199002_a(location);
                        try {
                            sources.put(id, (ShaderProgram)ShaderProgram.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)new JsonParser().parse((Reader)new InputStreamReader(resource.func_199027_b()))).getOrThrow(false, arg_0 -> ((Logger)LOGGER).error(arg_0)));
                        }
                        finally {
                            if (resource == null) continue;
                            resource.close();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load shader program: " + id, (Throwable)e);
                    }
                }
                return sources;
            }, backgroundExecutor);
            return ((CompletableFuture)CompletableFuture.allOf(sourcesFuture, programsFuture).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenRunAsync(() -> {
                Map sources = (Map)sourcesFuture.join();
                Map programs = (Map)programsFuture.join();
                SHADERS.values().stream().flatMap(map -> map.values().stream()).forEach(GL20C::glDeleteShader);
                SHADERS.clear();
                PROGRAMS.clear();
                PROGRAMS.putAll(programs);
                for (ShaderProgram.Shader type : sources.keySet()) {
                    for (Map.Entry entry : ((Map)sources.get((Object)type)).entrySet()) {
                        if (!type.isSupported()) {
                            LOGGER.warn((Object)((Object)type) + "");
                        }
                        try {
                            SHADERS.computeIfAbsent(type, key -> new Object2IntArrayMap()).put((ResourceLocation)entry.getKey(), ShaderLoader.loadShader(ShaderLoader.preprocessShader((ResourceLocation)entry.getKey(), (String)entry.getValue(), type), type));
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to load " + type.getDisplayName() + " Shader: " + entry.getKey(), (Throwable)e);
                        }
                    }
                }
                INSTANCES.keySet().removeIf(instance -> instance.getProgram() == 0);
                INSTANCES.forEach((shaderInstance, program) -> {
                    try {
                        shaderInstance.setProgram(ShaderLoader.linkShaders(program, shaderInstance.getProgram()));
                    }
                    catch (Exception e) {
                        shaderInstance.free();
                        shaderInstance.setProgram(-1);
                        LOGGER.error("Failed to reload shader program: " + program, (Throwable)e);
                    }
                });
                LOGGER.info("Loaded " + sources.values().stream().mapToInt(Map::size).sum() + " shaders and " + programs.size() + " shader programs.");
            }, task -> RenderSystem.recordRenderCall(task::run));
        }

        @Override
        public ResourceLocation getPollenId() {
            return new ResourceLocation("pollen", "shaders");
        }
    }
}

