/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.shader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import gg.moonflower.pollen.pinwheel.api.client.shader.ShaderConst;
import java.util.Arrays;
import java.util.Optional;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public class ShaderProgram {
    public static final Codec<ShaderProgram> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.field_240908_a_.optionalFieldOf("vertex").forGetter(ShaderProgram::getVertexShader), (App)ResourceLocation.field_240908_a_.optionalFieldOf("fragment").forGetter(ShaderProgram::getFragmentShader), (App)ResourceLocation.field_240908_a_.optionalFieldOf("geometry").forGetter(ShaderProgram::getGeometryShader), (App)ResourceLocation.field_240908_a_.listOf().optionalFieldOf("compute").xmap(array -> array.map(list -> list.toArray(new ResourceLocation[0])), list -> list.map(Arrays::asList)).forGetter(ShaderProgram::getComputeShaders)).apply((Applicative)instance, (vertex, fragment, geometry, computeShaders) -> new ShaderProgram(vertex.orElse(null), fragment.orElse(null), geometry.orElse(null), computeShaders.orElseGet(() -> new ResourceLocation[0]))));
    private final ResourceLocation vertexShader;
    private final ResourceLocation fragmentShader;
    private final ResourceLocation geometryShader;
    private final ResourceLocation[] computeShaders;

    public ShaderProgram(@Nullable ResourceLocation vertexShader, @Nullable ResourceLocation fragmentShader, @Nullable ResourceLocation geometryShader, ResourceLocation[] computeShaders) {
        this.vertexShader = vertexShader;
        this.fragmentShader = fragmentShader;
        this.geometryShader = geometryShader;
        this.computeShaders = computeShaders;
    }

    public Optional<ResourceLocation> getVertexShader() {
        return Optional.ofNullable(this.vertexShader);
    }

    public Optional<ResourceLocation> getFragmentShader() {
        return Optional.ofNullable(this.fragmentShader);
    }

    public Optional<ResourceLocation> getGeometryShader() {
        return Optional.ofNullable(this.geometryShader);
    }

    public Optional<ResourceLocation[]> getComputeShaders() {
        return this.computeShaders.length == 0 ? Optional.empty() : Optional.of(this.computeShaders);
    }

    public static enum Shader {
        VERTEX("Vertex", ".vert", 35633),
        FRAGMENT("Fragment", ".frag", 35632),
        GEOMETRY("Geometry", ".geom", 36313, ShaderConst.isGeometrySupported()),
        COMPUTE("Compute", ".comp", 37305, ShaderConst.isComputeSupported());

        private final String displayName;
        private final String extension;
        private final int type;
        private final boolean supported;

        private Shader(String displayName, String extension, int type, boolean supported) {
            this.displayName = displayName;
            this.extension = extension;
            this.type = type;
            this.supported = supported;
        }

        private Shader(String displayName, String extension, int type) {
            this(displayName, extension, type, true);
        }

        @Nullable
        public static Shader byExtension(String fileName) {
            for (Shader type : Shader.values()) {
                if (!fileName.endsWith(type.extension)) continue;
                return type;
            }
            return null;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getExtension() {
            return this.extension;
        }

        public int getGLType() {
            return this.type;
        }

        public boolean isSupported() {
            return this.supported;
        }
    }
}

