/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.client.texture;

import gg.moonflower.pollen.api.registry.resource.PollinatedPreparableReloadListener;
import gg.moonflower.pollen.api.registry.resource.ResourceRegistry;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.client.texture.TextureTableLoader;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import gg.moonflower.pollen.pinwheel.core.client.texture.GeometryTextureSpriteUploader;
import gg.moonflower.pollen.pinwheel.core.client.texture.LocalTextureTableLoader;
import gg.moonflower.pollen.pinwheel.core.client.texture.StaticTextureTableLoader;
import gg.moonflower.pollen.pinwheel.core.client.util.DynamicReloader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Unit;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class GeometryTextureManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Reloader RELOADER = new Reloader();
    private static final DynamicReloader DYNAMIC_RELOADER = new DynamicReloader();
    private static final Set<TextureTableLoader> PROVIDERS = new HashSet<TextureTableLoader>();
    private static final Map<ResourceLocation, GeometryModelTextureTable> TEXTURES = new HashMap<ResourceLocation, GeometryModelTextureTable>();
    private static GeometryTextureSpriteUploader spriteUploader;

    private GeometryTextureManager() {
    }

    @ApiStatus.Internal
    public static void init() {
        ResourceRegistry.registerReloadListener(ResourcePackType.CLIENT_RESOURCES, RELOADER);
        GeometryTextureManager.addProvider(new LocalTextureTableLoader());
    }

    public static void addTexture(ResourceLocation location, GeometryModelTextureTable texture, @Nullable String hashTable) {
        GeometryTextureManager.addProvider(new StaticTextureTableLoader(location, texture, hashTable));
    }

    public static void addProvider(TextureTableLoader provider) {
        PROVIDERS.add(provider);
    }

    public static GeometryModelTextureTable getTextures(ResourceLocation location) {
        return TEXTURES.computeIfAbsent(location, key -> {
            LOGGER.warn("Unknown texture table with key '{}'", (Object)location);
            return GeometryModelTextureTable.EMPTY;
        });
    }

    public static CompletableFuture<Unit> reload(boolean showLoadingScreen) {
        return DYNAMIC_RELOADER.reload(showLoadingScreen);
    }

    public static GeometryAtlasTexture getAtlas() {
        return spriteUploader;
    }

    public static Collection<GeometryModelTextureTable> getAllTextures() {
        return TEXTURES.values();
    }

    public static boolean isReloading() {
        return DYNAMIC_RELOADER.isReloading();
    }

    static {
        DYNAMIC_RELOADER.addListener(RELOADER);
    }

    private static class Reloader
    implements PollinatedPreparableReloadListener {
        private Reloader() {
        }

        public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
            return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])PROVIDERS.stream().map(provider -> provider.func_215226_a(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor)).toArray(CompletableFuture[]::new)).thenApplyAsync(a -> {
                HashMap textures = new HashMap();
                HashSet hashTables = new HashSet();
                PROVIDERS.forEach(provider -> {
                    try {
                        provider.addTextures((location, texture) -> {
                            if (textures.put(location, texture) != null) {
                                LOGGER.warn("Texture at location '" + location + "' already exists and is being overridden.");
                            }
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("Provider " + provider + " failed to gather textures", (Throwable)e);
                    }
                });
                PROVIDERS.forEach(provider -> provider.addHashTables(hashTables::add));
                return Pair.of(textures, (Object)hashTables.toArray(new String[0]));
            }, backgroundExecutor)).thenComposeAsync(pair -> {
                if (spriteUploader == null) {
                    spriteUploader = new GeometryTextureSpriteUploader(Minecraft.func_71410_x().func_110434_K());
                }
                return spriteUploader.setTextures((Map)pair.getLeft(), (String[])pair.getRight()).func_215226_a(stage, resourceManager, preparationsProfiler, reloadProfiler, backgroundExecutor, gameExecutor);
            }, gameExecutor)).thenCompose(arg_0 -> ((IFutureReloadListener.IStage)stage).func_216872_a(arg_0))).thenAcceptAsync(textures -> {
                TEXTURES.clear();
                PROVIDERS.forEach(provider -> provider.addTextures((location, texture) -> {
                    if (TEXTURES.put(location, texture) != null) {
                        LOGGER.warn("Texture at location '" + location + "' already exists and is being overridden.");
                    }
                }));
            }, gameExecutor);
        }

        @Override
        public ResourceLocation getPollenId() {
            return new ResourceLocation("pollen", "geometry_texture_manager");
        }
    }
}

