/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.api.common.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;

public class TextureHashGenerator {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            throw new IllegalArgumentException("First argument is expected to be url base.");
        }
        String urlBase = args[0];
        Path source = Paths.get("src/generated/input", new String[0]);
        Path result = Paths.get("src/generated/hashes.json", new String[0]);
        if (!Files.exists(source, new LinkOption[0])) {
            Files.createDirectories(source, new FileAttribute[0]);
            return;
        }
        JsonObject hashes = new JsonObject();
        Files.walk(source, new FileVisitOption[0]).forEach(child -> {
            if (!Files.isRegularFile(child, new LinkOption[0])) {
                return;
            }
            try (FileInputStream stream = new FileInputStream(child.toFile());){
                hashes.addProperty(urlBase + child.toString().replaceAll("\\\\", "/").substring("src/generated/input/".length()), DigestUtils.md5Hex((byte[])IOUtils.toByteArray((InputStream)stream)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        if (!Files.exists(result, new LinkOption[0])) {
            Files.createFile(result, new FileAttribute[0]);
        }
        try (FileOutputStream os = new FileOutputStream(result.toFile());){
            IOUtils.write((String)GSON.toJson((JsonElement)hashes), (OutputStream)os, (Charset)StandardCharsets.UTF_8);
        }
    }
}

