/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client;

import gg.moonflower.pollen.api.event.events.network.ClientNetworkEvents;
import gg.moonflower.pollen.pinwheel.api.client.blockdata.BlockData;
import gg.moonflower.pollen.pinwheel.api.client.blockdata.BlockDataKey;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IBlockReader;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BlockDataStorage {
    private static final Map<IBlockReader, BlockDataStorage> DATA = new WeakHashMap<IBlockReader, BlockDataStorage>(3);
    private final IBlockReader level;
    private final Map<BlockPos, Map<BlockDataKey<?>, BlockData<?>>> data;

    private BlockDataStorage(IBlockReader level) {
        this.level = level;
        this.data = new HashMap();
    }

    public <T> BlockData<T> get(BlockDataKey<T> key, BlockPos pos) {
        BlockState state = this.level.func_180495_p(pos);
        Map map = this.data.computeIfAbsent(pos.func_185334_h(), __ -> new HashMap());
        if (map.containsKey(key) && !key.getFilter().test(state)) {
            map.remove(key);
        }
        return map.computeIfAbsent(key, x$0 -> new BlockDataImpl((BlockDataKey)x$0));
    }

    public void invalidateChunk(ChunkPos chunkPos) {
        this.data.keySet().removeIf(pos -> pos.func_177958_n() >= chunkPos.func_180334_c() && pos.func_177958_n() < chunkPos.func_180332_e() && pos.func_177952_p() >= chunkPos.func_180333_d() && pos.func_177952_p() < chunkPos.func_180330_f());
    }

    public static BlockDataStorage get(IBlockReader level) {
        return DATA.computeIfAbsent(level, BlockDataStorage::new);
    }

    public void update(BlockState state, BlockPos pos) {
        if (!this.data.containsKey(pos)) {
            return;
        }
        Map<BlockDataKey<?>, BlockData<?>> map = this.data.get(pos);
        map.keySet().removeIf(key -> !key.getFilter().test(state));
    }

    static {
        ClientNetworkEvents.LOGOUT.register((controller, player, connection) -> DATA.clear());
    }

    private static class BlockDataImpl<T>
    implements BlockData<T> {
        private final Supplier<T> defaultValue;
        private T value;

        private BlockDataImpl(BlockDataKey<T> key) {
            this.defaultValue = key.getDefault();
            this.value = key.getDefault().get();
        }

        @Override
        public void set(@Nullable T value) {
            this.value = value != null ? value : this.defaultValue.get();
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

