/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.animation;

import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationParser;
import gg.moonflower.pollen.pinwheel.api.common.util.BackgroundLoader;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class LocalAnimationLoader
implements BackgroundLoader<Map<ResourceLocation, AnimationData>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String folder;

    public LocalAnimationLoader() {
        this("animations");
    }

    public LocalAnimationLoader(String folder) {
        this.folder = folder.isEmpty() ? "" : folder + "/";
    }

    @Override
    public CompletableFuture<Map<ResourceLocation, AnimationData>> reload(IResourceManager resourceManager, Executor backgroundExecutor, Executor gameExecutor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<ResourceLocation, AnimationData> animationData = new HashMap<ResourceLocation, AnimationData>();
            for (ResourceLocation animationLocation : resourceManager.func_199003_a(this.folder, name -> name.endsWith(".json"))) {
                try {
                    IResource resource = resourceManager.func_199002_a(animationLocation);
                    try {
                        AnimationData[] animations;
                        for (AnimationData animation : animations = AnimationParser.parse(new InputStreamReader(resource.func_199027_b()))) {
                            ResourceLocation id = new ResourceLocation(animationLocation.func_110624_b(), animation.getName());
                            if (animationData.put(id, animation) == null) continue;
                            LOGGER.warn("Duplicate animation: " + id);
                        }
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to load animation: " + animationLocation.func_110624_b() + ":" + animationLocation.func_110623_a().substring(this.folder.length(), animationLocation.func_110623_a().length() - 5), (Throwable)e);
                }
            }
            return animationData;
        }, backgroundExecutor);
    }
}

