/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.geometry;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gg.moonflower.pollen.molangcompiler.api.MolangEnvironment;
import gg.moonflower.pollen.molangcompiler.api.MolangRuntime;
import gg.moonflower.pollen.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.pollen.molangcompiler.api.exception.MolangException;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModel;
import gg.moonflower.pollen.pinwheel.api.client.animation.AnimatedModelPart;
import gg.moonflower.pollen.pinwheel.api.client.geometry.GeometryModel;
import gg.moonflower.pollen.pinwheel.api.common.animation.AnimationData;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.core.client.geometry.BoneModelPart;
import gg.moonflower.pollen.pinwheel.core.client.geometry.MolangCache;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.Direction;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class BedrockGeometryModel
extends Model
implements GeometryModel,
AnimatedModel {
    private static final Logger LOGGER = LogManager.getLogger((String)"MoLang");
    private static final ThreadLocal<MolangCache> MOLANG_CACHE = ThreadLocal.withInitial(MolangCache::new);
    private static final MolangJavaFunction APPROX_EQUALS = context -> {
        if (context.getParameters() <= 1) {
            return 1.0f;
        }
        float first = context.resolve(0);
        for (int i = 1; i < context.getParameters(); ++i) {
            if (!((double)Math.abs(context.resolve(i) - first) > 1.0E-7)) continue;
            return 0.0f;
        }
        return 1.0f;
    };
    private static final MolangJavaFunction LAST_FRAME_TIME = context -> {
        int wrappedIndex;
        FrameTimer frameTimer = Minecraft.func_71410_x().func_181539_aj();
        long[] log = frameTimer.func_181746_c();
        int index = (int)Math.min(context.resolve(0), (float)(log.length - 1));
        if (index == 0) {
            return (float)log[frameTimer.func_181750_b()] / 1.0E9f;
        }
        if (index < 0) {
            throw new MolangException("Invalid argument for last_frame_time(): " + index);
        }
        for (wrappedIndex = frameTimer.func_181750_b() - index; wrappedIndex < 0; wrappedIndex += 240) {
        }
        return (float)log[frameTimer.func_181751_b(wrappedIndex)] / 1.0E9f;
    };
    private static final MolangJavaFunction AVERAGE_FRAME_TIME = context -> BedrockGeometryModel.applyFrame((int)context.resolve(0), stream -> OptionalLong.of(stream.sum())) / context.resolve(0);
    private static final MolangJavaFunction MAX_FRAME_TIME = context -> BedrockGeometryModel.applyFrame((int)context.resolve(0), LongStream::max);
    private static final MolangJavaFunction MIN_FRAME_TIME = context -> BedrockGeometryModel.applyFrame((int)context.resolve(0), LongStream::min);
    private static final MolangJavaFunction CAMERA_ROTATION = context -> {
        int param = (int)context.resolve(0);
        if (param < 0 || param >= 2) {
            throw new MolangException("Invalid argument for camera_rotation: " + param);
        }
        ActiveRenderInfo camera = Minecraft.func_71410_x().field_71460_t.func_215316_n();
        return param == 0 ? camera.func_216777_e() : camera.func_216778_f();
    };
    private static final MolangJavaFunction LOG = context -> {
        float value = context.resolve(0);
        LOGGER.info((Object)Float.valueOf(value));
        return value;
    };
    private static final Vector3f POSITION = new Vector3f();
    private static final Vector3f ROTATION = new Vector3f();
    private static final Vector3f SCALE = new Vector3f();
    private final Map<String, AnimatedModelPart.AnimationPose> transformations;
    private final Map<String, BoneModelPart> modelParts;
    private final Set<BoneModelPart> renderParts;
    private final String[] modelKeys;
    private final String[] textureKeys;
    private String activeMaterial;

    public BedrockGeometryModel(int textureWidth, int textureHeight, GeometryModelData.Bone[] bones) {
        super(RenderType::func_228640_c_);
        this.field_78090_t = textureWidth;
        this.field_78089_u = textureHeight;
        this.transformations = new HashMap<String, AnimatedModelPart.AnimationPose>();
        this.modelParts = new HashMap<String, BoneModelPart>();
        this.renderParts = new HashSet<BoneModelPart>();
        HashSet<String> textures = new HashSet<String>();
        for (GeometryModelData.Bone bone2 : bones) {
            for (GeometryModelData.Cube cube : bone2.getCubes()) {
                for (Direction direction : Direction.values()) {
                    GeometryModelData.CubeUV uv = cube.getUV(direction);
                    if (uv == null) continue;
                    textures.add(uv.getMaterialInstance());
                }
            }
            if (bone2.getPolyMesh() == null) continue;
            textures.add("poly_mesh.texture");
        }
        this.textureKeys = textures.toArray(new String[0]);
        if (bones.length == 0) {
            this.modelKeys = new String[0];
            return;
        }
        Map<String, Pair> boneLookup = Arrays.stream(bones).map(bone -> Pair.of((Object)bone, (Object)new BoneModelPart(this, (GeometryModelData.Bone)bone))).collect(Collectors.toMap(pair -> ((GeometryModelData.Bone)pair.getKey()).getName(), pair -> pair));
        HashMap<GeometryModelData.Bone, String> parts = new HashMap<GeometryModelData.Bone, String>();
        List unprocessedBones = Arrays.stream(bones).map(GeometryModelData.Bone::getName).collect(Collectors.toList());
        while (!unprocessedBones.isEmpty()) {
            Pair pair2 = boneLookup.get(unprocessedBones.remove(0));
            GeometryModelData.Bone currentBone = (GeometryModelData.Bone)pair2.getLeft();
            String parent = currentBone.getParent();
            if (parent != null) {
                if (parent.startsWith("parent.")) {
                    parts.put(currentBone, parent.substring("parent.".length()));
                } else {
                    if (!boneLookup.containsKey(parent)) {
                        throw new IllegalStateException("Unknown bone '" + parent + "'");
                    }
                    ModelRenderer parentRenderer = (ModelRenderer)boneLookup.get(parent).getRight();
                    parentRenderer.func_78792_a((ModelRenderer)pair2.getRight());
                }
            }
            unprocessedBones.remove(currentBone.getName());
        }
        for (Pair pair3 : boneLookup.values()) {
            GeometryModelData.Bone currentBone = (GeometryModelData.Bone)pair3.getLeft();
            this.modelParts.put(currentBone.getName(), (BoneModelPart)pair3.getRight());
            if (currentBone.getParent() != null && !currentBone.getParent().startsWith("parent.")) continue;
            this.renderParts.add((BoneModelPart)pair3.getRight());
        }
        this.modelKeys = parts.values().toArray(new String[0]);
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
    }

    @Override
    public void render(String material, GeometryModelTexture texture, MatrixStack matrixStack, IVertexBuilder builder, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.activeMaterial = material;
        for (BoneModelPart part : this.renderParts) {
            part.func_228309_a_(matrixStack, builder, packedLight, packedOverlay, red, green, blue, alpha);
        }
        this.activeMaterial = "texture";
    }

    @Override
    public void resetTransformation() {
        this.modelParts.values().forEach(renderer -> renderer.resetTransform(true));
    }

    @Override
    public void copyAngles(@Nullable String parent, ModelRenderer limbRenderer) {
        this.modelParts.values().stream().filter(part -> Objects.equals(part.getBone().getParent(), parent)).forEach(renderer -> renderer.func_217177_a(limbRenderer));
    }

    @Override
    public Optional<ModelRenderer> getModelPart(String part) {
        return Optional.ofNullable((ModelRenderer)this.modelParts.get(part));
    }

    @Override
    public ModelRenderer[] getChildRenderers(String part) {
        return (ModelRenderer[])this.modelParts.values().stream().filter(boneModelPart -> part.equals(boneModelPart.getBone().getParent())).toArray(ModelRenderer[]::new);
    }

    @Override
    public ModelRenderer[] getModelParts() {
        return this.modelParts.values().toArray(new ModelRenderer[0]);
    }

    @Override
    public String[] getParentModelKeys() {
        return this.modelKeys;
    }

    @Override
    public String[] getMaterialKeys() {
        return this.textureKeys;
    }

    @Override
    public float getTextureWidth() {
        return this.field_78090_t;
    }

    @Override
    public float getTextureHeight() {
        return this.field_78089_u;
    }

    @Override
    public void applyAnimations(float animationTime, MolangRuntime.Builder runtime, AnimationData ... animations) {
        if (animations.length == 0) {
            return;
        }
        runtime.setQuery("approx_eq", -1, APPROX_EQUALS);
        runtime.setQuery("average_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.func_71410_x().func_181539_aj();
            return Float.valueOf((float)frameTimer.func_181746_c()[frameTimer.func_181750_b()] / 1.0E9f);
        });
        runtime.setQuery("delta_time", Minecraft.func_71410_x().func_184121_ak());
        runtime.setQuery("life_time", animationTime);
        runtime.setQuery("average_frame_time", 1, AVERAGE_FRAME_TIME);
        runtime.setQuery("last_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.func_71410_x().func_181539_aj();
            return Float.valueOf((float)frameTimer.func_181746_c()[frameTimer.func_181750_b()] / 1.0E9f);
        });
        runtime.setQuery("last_frame_time", 1, LAST_FRAME_TIME);
        runtime.setQuery("maximum_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.func_71410_x().func_181539_aj();
            return Float.valueOf((float)frameTimer.func_181746_c()[frameTimer.func_181750_b()] / 1.0E9f);
        });
        runtime.setQuery("maximum_frame_time", 1, MAX_FRAME_TIME);
        runtime.setQuery("minimum_frame_time", () -> {
            FrameTimer frameTimer = Minecraft.func_71410_x().func_181539_aj();
            return Float.valueOf((float)frameTimer.func_181746_c()[frameTimer.func_181750_b()] / 1.0E9f);
        });
        runtime.setQuery("minimum_frame_time", 1, MIN_FRAME_TIME);
        runtime.setQuery("camera_rotation", 1, CAMERA_ROTATION);
        runtime.setQuery("log", 1, LOG);
        animationTime %= AnimatedModel.getAnimationLength(animationTime, animations);
        this.transformations.values().forEach(AnimatedModelPart.AnimationPose::reset);
        MolangCache cache = MOLANG_CACHE.get();
        AnimationData[] animationDataArray = animations;
        int n = animationDataArray.length;
        for (int i = 0; i < n; ++i) {
            float blendWeight;
            float localAnimationTime = animationTime;
            AnimationData animation = animationDataArray[i];
            if (localAnimationTime > animation.getAnimationLength()) {
                localAnimationTime = animation.getAnimationLength();
            }
            if ((double)Math.abs(blendWeight = cache.resolve(runtime, 1.0f, animation.getBlendWeight())) <= 1.0E-6) continue;
            for (AnimationData.BoneAnimation boneAnimation : animation.getBoneAnimations()) {
                if (!this.modelParts.containsKey(boneAnimation.getName())) continue;
                POSITION.func_195905_a(0.0f, 0.0f, 0.0f);
                ROTATION.func_195905_a(0.0f, 0.0f, 0.0f);
                SCALE.func_195905_a(1.0f, 1.0f, 1.0f);
                BedrockGeometryModel.get(localAnimationTime, cache, cache.get(runtime, 0.0f), 0.0f, boneAnimation.getPositionFrames(), POSITION);
                BedrockGeometryModel.get(localAnimationTime, cache, cache.get(runtime, 0.0f), 0.0f, boneAnimation.getRotationFrames(), ROTATION);
                BedrockGeometryModel.get(localAnimationTime, cache, cache.get(runtime, 1.0f), 1.0f, boneAnimation.getScaleFrames(), SCALE);
                this.transformations.computeIfAbsent(boneAnimation.getName(), key -> new AnimatedModelPart.AnimationPose()).add(POSITION.func_195899_a() * blendWeight, POSITION.func_195900_b() * blendWeight, POSITION.func_195902_c() * blendWeight, ROTATION.func_195899_a() * blendWeight, ROTATION.func_195900_b() * blendWeight, ROTATION.func_195902_c() * blendWeight, (SCALE.func_195899_a() - 1.0f) * blendWeight, (SCALE.func_195900_b() - 1.0f) * blendWeight, (SCALE.func_195902_c() - 1.0f) * blendWeight);
            }
        }
        cache.clear();
        this.transformations.forEach((name, pose) -> {
            AnimatedModelPart.AnimationPose p = this.modelParts.get(name).getAnimationPose();
            p.reset();
            p.add(pose.getPosition().func_195899_a(), pose.getPosition().func_195900_b(), pose.getPosition().func_195902_c(), pose.getRotation().func_195899_a(), pose.getRotation().func_195900_b(), pose.getRotation().func_195902_c(), pose.getScale().func_195899_a() - 1.0f, pose.getScale().func_195900_b() - 1.0f, pose.getScale().func_195902_c() - 1.0f);
        });
    }

    @Override
    public GeometryModelData.Locator[] getLocators(String part) {
        return this.getModelPart(part).map(modelPart -> {
            if (!(modelPart instanceof AnimatedModelPart)) {
                return new GeometryModelData.Locator[0];
            }
            return ((AnimatedModelPart)modelPart).getLocators();
        }).orElseGet(() -> new GeometryModelData.Locator[0]);
    }

    public String getActiveMaterial() {
        return this.activeMaterial;
    }

    private static void get(float animationTime, MolangCache cache, MolangEnvironment environment, float startValue, AnimationData.KeyFrame[] frames, Vector3f result) {
        if (frames.length == 1) {
            float x = cache.resolve(environment, frames[0].getTransformPostX());
            float y = cache.resolve(environment, frames[0].getTransformPostY());
            float z = cache.resolve(environment, frames[0].getTransformPostZ());
            result.func_195905_a(x, y, z);
            return;
        }
        for (int i = 0; i < frames.length; ++i) {
            AnimationData.KeyFrame to = frames[i];
            if (to.getTime() < animationTime && i < frames.length - 1 || to.getTime() == 0.0f) continue;
            AnimationData.KeyFrame from = i == 0 ? null : frames[i - 1];
            float progress = from == null ? animationTime / to.getTime() : Math.min(1.0f, (animationTime - from.getTime()) / (to.getTime() - from.getTime()));
            switch (to.getLerpMode()) {
                case LINEAR: {
                    BedrockGeometryModel.lerp(progress, cache, environment, startValue, from, to, result);
                    break;
                }
                case CATMULLROM: {
                    BedrockGeometryModel.catmullRom(progress, cache, environment, startValue, i > 1 ? frames[i - 2] : null, from, to, i < frames.length - 1 ? frames[i + 1] : null, result);
                }
            }
            break;
        }
    }

    private static void lerp(float progress, MolangCache cache, MolangEnvironment environment, float startValue, @Nullable AnimationData.KeyFrame from, AnimationData.KeyFrame to, Vector3f result) {
        float fromX = from == null ? startValue : cache.resolve(environment, from.getTransformPostX());
        float fromY = from == null ? startValue : cache.resolve(environment, from.getTransformPostY());
        float fromZ = from == null ? startValue : cache.resolve(environment, from.getTransformPostZ());
        float x = MathHelper.func_219799_g((float)progress, (float)fromX, (float)cache.resolve(environment, to.getTransformPreX()));
        float y = MathHelper.func_219799_g((float)progress, (float)fromY, (float)cache.resolve(environment, to.getTransformPreY()));
        float z = MathHelper.func_219799_g((float)progress, (float)fromZ, (float)cache.resolve(environment, to.getTransformPreZ()));
        result.func_195905_a(x, y, z);
    }

    private static void catmullRom(float progress, MolangCache cache, MolangEnvironment environment, float startValue, @Nullable AnimationData.KeyFrame before, @Nullable AnimationData.KeyFrame from, AnimationData.KeyFrame to, @Nullable AnimationData.KeyFrame after, Vector3f result) {
        float fromX = from == null ? startValue : cache.resolve(environment, from.getTransformPostX());
        float fromY = from == null ? startValue : cache.resolve(environment, from.getTransformPostY());
        float fromZ = from == null ? startValue : cache.resolve(environment, from.getTransformPostZ());
        float beforeX = before == null ? fromX : cache.resolve(environment, before.getTransformPostX());
        float beforeY = before == null ? fromY : cache.resolve(environment, before.getTransformPostY());
        float beforeZ = before == null ? fromZ : cache.resolve(environment, before.getTransformPostZ());
        float toX = cache.resolve(environment, to.getTransformPreX());
        float toY = cache.resolve(environment, to.getTransformPreY());
        float toZ = cache.resolve(environment, to.getTransformPreZ());
        float afterX = after == null ? toX : cache.resolve(environment, after.getTransformPreX());
        float afterY = after == null ? toY : cache.resolve(environment, after.getTransformPreY());
        float afterZ = after == null ? toZ : cache.resolve(environment, after.getTransformPreZ());
        result.func_195905_a(BedrockGeometryModel.catmullRom(beforeX, fromX, toX, afterX, progress), BedrockGeometryModel.catmullRom(beforeY, fromY, toY, afterY, progress), BedrockGeometryModel.catmullRom(beforeZ, fromZ, toZ, afterZ, progress));
    }

    private static float catmullRom(float p0, float p1, float p2, float p3, float t) {
        return 0.5f * (2.0f * p1 + (-p0 + p2) * t + (2.0f * p0 - 5.0f * p1 + 4.0f * p2 - p3) * t * t + (-p0 + 3.0f * p1 - 3.0f * p2 + p3) * t * t * t);
    }

    private static float applyFrame(int count, FrameFunction terminator) throws MolangException {
        int wrappedIndex;
        FrameTimer frameTimer = Minecraft.func_71410_x().func_181539_aj();
        long[] log = frameTimer.func_181746_c();
        int duration = Math.min(count, log.length - 1);
        if (duration == 0) {
            return (float)frameTimer.func_181746_c()[frameTimer.func_181750_b()] / 1.0E9f;
        }
        if (duration < 0) {
            throw new MolangException("Invalid argument for last_frame_time(): " + duration);
        }
        for (wrappedIndex = frameTimer.func_181750_b() - duration; wrappedIndex < 0; wrappedIndex += 240) {
        }
        int finalWrappedIndex = wrappedIndex;
        return (float)terminator.apply(LongStream.range(0L, duration).map(i -> frameTimer.func_181746_c()[frameTimer.func_181751_b((int)((long)finalWrappedIndex + i))])).orElse(0L) / 1.0E9f;
    }

    @FunctionalInterface
    private static interface FrameFunction {
        public OptionalLong apply(LongStream var1) throws MolangException;
    }
}

