/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.client.texture;

import com.google.common.base.Stopwatch;
import com.google.gson.JsonObject;
import gg.moonflower.pollen.pinwheel.api.client.FileCache;
import gg.moonflower.pollen.pinwheel.api.client.texture.GeometryAtlasTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTexture;
import gg.moonflower.pollen.pinwheel.api.common.texture.GeometryModelTextureTable;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.codec.binary.Base32;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class GeometryTextureSpriteUploader
extends ReloadListener<AtlasTexture.SheetData>
implements GeometryAtlasTexture,
AutoCloseable {
    public static final ResourceLocation ATLAS_LOCATION = new ResourceLocation("pollen", "textures/atlas/geometry.png");
    private static final Logger LOGGER = LogManager.getLogger();
    private final AtlasTexture textureAtlas = new AtlasTexture(ATLAS_LOCATION);
    private final Set<GeometryModelTexture> textures = new HashSet<GeometryModelTexture>();
    private String[] hashTables = new String[0];

    public GeometryTextureSpriteUploader(TextureManager textureManager) {
        textureManager.func_229263_a_(this.textureAtlas.func_229223_g_(), (Texture)this.textureAtlas);
    }

    private void beginStitch(long startTime, Stopwatch stopwatch) {
        stopwatch.start();
    }

    private void endStitch(Stopwatch stopwatch) {
        stopwatch.stop();
        LOGGER.debug("Took " + stopwatch + " to process " + this.textures.size() + " geometry textures");
    }

    @Override
    public ResourceLocation getAtlasLocation() {
        return ATLAS_LOCATION;
    }

    @Override
    public TextureAtlasSprite getSprite(ResourceLocation location) {
        return this.textureAtlas.func_195424_a(location);
    }

    protected AtlasTexture.SheetData prepare(IResourceManager resourceManager, IProfiler profiler) {
        try (OnlineRepository onlineRepository = new OnlineRepository(this.hashTables);){
            profiler.func_219894_a();
            profiler.func_76320_a("stitching");
            Stopwatch stopwatch = Stopwatch.createUnstarted();
            this.beginStitch(System.currentTimeMillis(), stopwatch);
            AtlasTexture.SheetData sheetData = this.textureAtlas.func_229220_a_((IResourceManager)new OnlineResourceManager(resourceManager, onlineRepository, this.textures.stream().filter(texture -> texture.getType() == GeometryModelTexture.Type.ONLINE).collect(Collectors.toSet())), this.textures.stream().filter(texture -> texture.getType() == GeometryModelTexture.Type.LOCATION || texture.getType() == GeometryModelTexture.Type.ONLINE).map(GeometryModelTexture::getLocation).distinct(), profiler, Minecraft.func_71410_x().field_71474_y.field_151442_I);
            this.endStitch(stopwatch);
            profiler.func_76319_b();
            profiler.func_219897_b();
            AtlasTexture.SheetData sheetData2 = sheetData;
            return sheetData2;
        }
    }

    protected void apply(AtlasTexture.SheetData sheetData, IResourceManager resourceManager, IProfiler profiler) {
        profiler.func_219894_a();
        profiler.func_76320_a("upload");
        this.textureAtlas.func_215260_a(sheetData);
        profiler.func_76319_b();
        profiler.func_219897_b();
    }

    @Override
    public void close() {
        this.textureAtlas.func_195419_g();
    }

    public GeometryTextureSpriteUploader setTextures(Map<ResourceLocation, GeometryModelTextureTable> textures, String[] hashTables) {
        this.textures.clear();
        this.textures.addAll(textures.values().stream().flatMap(table -> table.getTextures().stream().flatMap(Arrays::stream)).collect(Collectors.toSet()));
        this.hashTables = hashTables;
        return this;
    }

    private static class OnlineRepository
    implements AutoCloseable {
        private final ExecutorService executor = FileCache.createOnlineWorker();
        private final FileCache hashedCache;
        private final FileCache cache;
        private final Map<String, CompletableFuture<Path>> resources;

        private OnlineRepository(String[] hashTableUrls) {
            this.hashedCache = FileCache.hashed(this.executor, hashTableUrls);
            this.cache = FileCache.timed(this.executor, 1L, TimeUnit.DAYS);
            this.resources = new HashMap<String, CompletableFuture<Path>>();
        }

        public CompletableFuture<Path> requestResource(String url, boolean cache, boolean ignoreMissing) {
            return this.resources.computeIfAbsent(url, key -> cache ? this.hashedCache.requestResource(url, ignoreMissing) : this.cache.requestResource(url, ignoreMissing));
        }

        @Override
        public void close() {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOGGER.warn("Took more than 10 seconds to terminate online worker");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to terminate online worker", (Throwable)e);
            }
        }
    }

    private static class OnlineResourceManager
    implements IResourceManager {
        private final IResourceManager parent;
        private final OnlineRepository repository;
        private final Set<String> uncached;
        private final Map<String, Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>>> onlineLocations;

        private OnlineResourceManager(IResourceManager parent, OnlineRepository repository, Set<GeometryModelTexture> onlineTextures) {
            this.parent = parent;
            this.repository = repository;
            this.uncached = onlineTextures.stream().filter(texture -> !texture.canCache()).map(GeometryModelTexture::getData).collect(Collectors.toSet());
            this.onlineLocations = onlineTextures.stream().map(GeometryModelTexture::getData).distinct().collect(Collectors.toMap(url -> url, this::updateCache));
        }

        @Nullable
        private static String parseUrl(ResourceLocation location) {
            String[] parts = location.func_110623_a().split("/");
            if (parts[parts.length - 1].startsWith("base32")) {
                return new String(new Base32().decode(parts[parts.length - 1].substring(6).toUpperCase(Locale.ROOT).replaceAll("_", "=")));
            }
            return null;
        }

        @Nullable
        private static InputStream read(CompletableFuture<Path> pathFuture) {
            try {
                Path path = pathFuture.join();
                return path == null ? null : new FileInputStream(path.toFile());
            }
            catch (Exception e) {
                LOGGER.error("Took too long to fetch texture data", (Throwable)e);
                return null;
            }
        }

        private Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>> updateCache(String url) {
            String extension = FilenameUtils.getExtension((String)url);
            String[] urlParts = url.split("." + extension);
            String metadataUrl = urlParts.length <= 1 ? url + ".mcmeta" : urlParts[0] + extension + ".mcmeta" + urlParts[1];
            CompletableFuture<Path> texturePath = this.repository.requestResource(url, !this.uncached.contains(url), false);
            CompletionStage metadataPath = this.repository.requestResource(metadataUrl, false, true).thenApplyAsync(path -> {
                JsonObject jsonObject;
                InputStream stream = OnlineResourceManager.read(CompletableFuture.completedFuture(path));
                if (stream == null) {
                    return null;
                }
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                try {
                    jsonObject = JSONUtils.func_212743_a((Reader)bufferedreader);
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            bufferedreader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                bufferedreader.close();
                return jsonObject;
            }, Util.func_240992_g_());
            return Pair.of(texturePath, (Object)metadataPath);
        }

        public Set<String> func_199001_a() {
            return this.parent.func_199001_a();
        }

        public IResource func_199002_a(ResourceLocation resourceLocation) throws IOException {
            String url = OnlineResourceManager.parseUrl(new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a().substring(9, resourceLocation.func_110623_a().length() - 4)));
            if (url != null) {
                if (!this.onlineLocations.containsKey(url)) {
                    throw new IOException("Failed to fetch texture data from '" + url + "'");
                }
                Pair<CompletableFuture<Path>, CompletableFuture<JsonObject>> files = this.onlineLocations.get(url);
                InputStream textureStream = OnlineResourceManager.read((CompletableFuture)files.getLeft());
                if (textureStream == null) {
                    throw new IOException("Failed to fetch texture data from '" + url + "'");
                }
                return new OnlineResource(url, resourceLocation, textureStream, (JsonObject)((CompletableFuture)files.getRight()).join());
            }
            return this.parent.func_199002_a(resourceLocation);
        }

        public boolean func_219533_b(ResourceLocation resourceLocation) {
            return resourceLocation.func_110623_a().startsWith("base32") || this.parent.func_219533_b(resourceLocation);
        }

        public List<IResource> func_199004_b(ResourceLocation resourceLocation) throws IOException {
            return this.parent.func_199004_b(resourceLocation);
        }

        public Collection<ResourceLocation> func_199003_a(String path, Predicate<String> filter) {
            return this.parent.func_199003_a(path, filter);
        }

        public Stream<IResourcePack> func_230232_b_() {
            return this.parent.func_230232_b_();
        }

        private static class OnlineResource
        implements IResource {
            private final String url;
            private final ResourceLocation textureLocation;
            private final InputStream stream;
            private final JsonObject metadataJson;

            private OnlineResource(String url, ResourceLocation textureLocation, InputStream stream, @Nullable JsonObject metadataJson) {
                this.url = url;
                this.textureLocation = textureLocation;
                this.stream = stream;
                this.metadataJson = metadataJson;
            }

            public ResourceLocation func_199029_a() {
                return this.textureLocation;
            }

            public InputStream func_199027_b() {
                return this.stream;
            }

            @Nullable
            public <T> T func_199028_a(IMetadataSectionSerializer<T> serializer) {
                if (this.metadataJson == null) {
                    return null;
                }
                String s = serializer.func_110483_a();
                return (T)(this.metadataJson.has(s) ? serializer.func_195812_a(JSONUtils.func_152754_s((JsonObject)this.metadataJson, (String)s)) : null);
            }

            public String func_199026_d() {
                return "pollen_online";
            }

            public void close() throws IOException {
                this.stream.close();
            }

            public String toString() {
                return "OnlineResource{url='" + this.url + '\'' + ", textureLocation=" + this.textureLocation + '}';
            }
        }
    }
}

