/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.pollen.pinwheel.core.common.geometry;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import gg.moonflower.pollen.api.util.JSONTupleParser;
import gg.moonflower.pollen.pinwheel.api.common.geometry.GeometryModelData;
import gg.moonflower.pollen.pinwheel.core.common.geometry.Geometry110Parser;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3f;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public final class Geometry180Parser {
    static final Gson GSON = new GsonBuilder().registerTypeAdapter(GeometryModelData.Poly.class, (Object)new GeometryModelData.Poly.Deserializer()).registerTypeAdapter(GeometryModelData.PolyMesh.class, (Object)new GeometryModelData.PolyMesh.Deserializer()).create();

    private Geometry180Parser() {
    }

    public static GeometryModelData[] parseModel(JsonElement json) throws JsonParseException {
        GeometryModelData[] geometryModelDataArray;
        JsonObject jsonObject = json.getAsJsonObject();
        GeometryModelData data = null;
        for (Map.Entry entry : jsonObject.entrySet()) {
            GeometryModelData.Bone[] bones;
            if (!((String)entry.getKey()).startsWith("geometry.")) continue;
            if (data != null) {
                throw new JsonSyntaxException("1.8.0 does not allow multiple geometry definitions per file.");
            }
            JsonObject object = JSONUtils.func_151210_l((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
            GeometryModelData.Description description = Geometry180Parser.parseDescription(((String)entry.getKey()).substring(9), object);
            if (object.has("bones")) {
                HashSet<String> usedNames = new HashSet<String>();
                JsonArray bonesJson = JSONUtils.func_151214_t((JsonObject)object, (String)"bones");
                bones = new GeometryModelData.Bone[bonesJson.size()];
                for (int j = 0; j < bones.length; ++j) {
                    bones[j] = Geometry180Parser.parseBone(JSONUtils.func_151210_l((JsonElement)bonesJson.get(j), (String)("bones[" + j + "]")));
                    if (usedNames.add(bones[j].getName())) continue;
                    throw new JsonSyntaxException("Duplicate bone: " + bones[j].getName());
                }
            } else {
                bones = new GeometryModelData.Bone[]{};
            }
            data = new GeometryModelData(description, bones);
        }
        if (data != null) {
            GeometryModelData[] geometryModelDataArray2 = new GeometryModelData[1];
            geometryModelDataArray = geometryModelDataArray2;
            geometryModelDataArray2[0] = data;
        } else {
            geometryModelDataArray = new GeometryModelData[]{};
        }
        return geometryModelDataArray;
    }

    private static GeometryModelData.Description parseDescription(String identifier, JsonObject json) throws JsonParseException {
        float visibleBoundsWidth = JSONUtils.func_151221_a((JsonObject)json, (String)"visible_bounds_width", (float)0.0f);
        float visibleBoundsHeight = JSONUtils.func_151221_a((JsonObject)json, (String)"visible_bounds_height", (float)0.0f);
        float[] visibleBoundsOffset = JSONTupleParser.getFloat(json, "visible_bounds_offset", 3, () -> new float[3]);
        int textureWidth = JSONUtils.func_151208_a((JsonObject)json, (String)"texturewidth", (int)256);
        int textureHeight = JSONUtils.func_151208_a((JsonObject)json, (String)"textureheight", (int)256);
        boolean preserveModelPose2588 = JSONUtils.func_151209_a((JsonObject)json, (String)"preserve_model_pose2588", (boolean)false);
        if (textureWidth == 0) {
            throw new JsonSyntaxException("Texture width must not be zero");
        }
        if (textureHeight == 0) {
            throw new JsonSyntaxException("Texture height must not be zero");
        }
        return new GeometryModelData.Description(identifier, visibleBoundsWidth, visibleBoundsHeight, new Vector3f(visibleBoundsOffset[0], visibleBoundsOffset[1], visibleBoundsOffset[2]), textureWidth, textureHeight, preserveModelPose2588);
    }

    private static GeometryModelData.Bone parseBone(JsonObject json) throws JsonParseException {
        String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
        boolean reset2588 = JSONUtils.func_151209_a((JsonObject)json, (String)"reset", (boolean)false);
        boolean neverRender2588 = JSONUtils.func_151209_a((JsonObject)json, (String)"neverrender", (boolean)false);
        String parent = JSONUtils.func_151219_a((JsonObject)json, (String)"parent", null);
        float[] pivot = JSONTupleParser.getFloat(json, "pivot", 3, () -> new float[3]);
        float[] rotation = JSONTupleParser.getFloat(json, "rotation", 3, () -> new float[3]);
        float[] bindPoseRotation2588 = JSONTupleParser.getFloat(json, "bind_pose_rotation2588", 3, () -> new float[3]);
        boolean mirror = JSONUtils.func_151209_a((JsonObject)json, (String)"mirror", (boolean)false);
        float inflate = JSONUtils.func_151221_a((JsonObject)json, (String)"inflate", (float)0.0f);
        boolean debug = JSONUtils.func_151209_a((JsonObject)json, (String)"debug", (boolean)false);
        GeometryModelData.Cube[] cubes = json.has("cubes") ? Geometry180Parser.parseCubes(json) : new GeometryModelData.Cube[]{};
        GeometryModelData.Locator[] locators = json.has("locators") ? Geometry110Parser.parseLocators(json) : new GeometryModelData.Locator[]{};
        GeometryModelData.PolyMesh polyMesh = json.has("poly_mesh") ? (GeometryModelData.PolyMesh)GSON.fromJson(json.get("poly_mesh"), GeometryModelData.PolyMesh.class) : null;
        return new GeometryModelData.Bone(name, reset2588, neverRender2588, parent, new Vector3f(pivot[0], pivot[1], pivot[2]), new Vector3f(rotation[0], rotation[1], rotation[2]), new Vector3f(bindPoseRotation2588[0], bindPoseRotation2588[1], bindPoseRotation2588[2]), mirror, inflate, debug, cubes, locators, polyMesh);
    }

    static GeometryModelData.Cube[] parseCubes(JsonObject json) {
        JsonArray cubesJson = JSONUtils.func_151214_t((JsonObject)json, (String)"cubes");
        GeometryModelData.Cube[] cubes = new GeometryModelData.Cube[cubesJson.size()];
        for (int i = 0; i < cubesJson.size(); ++i) {
            cubes[i] = Geometry180Parser.parseCube(JSONUtils.func_151210_l((JsonElement)cubesJson.get(i), (String)("cubes[" + i + "]")));
        }
        return cubes;
    }

    private static GeometryModelData.Cube parseCube(JsonObject json) throws JsonParseException {
        JsonObject cubeJson = json.getAsJsonObject();
        float[] origin = JSONTupleParser.getFloat(cubeJson, "origin", 3, () -> new float[3]);
        float[] size = JSONTupleParser.getFloat(cubeJson, "size", 3, () -> new float[3]);
        float[] rotation = JSONTupleParser.getFloat(cubeJson, "rotation", 3, () -> new float[3]);
        float[] pivot = JSONTupleParser.getFloat(cubeJson, "pivot", 3, () -> new float[]{origin[0] + size[0] / 2.0f, origin[1] + size[1] / 2.0f, origin[2] + size[2] / 2.0f});
        boolean overrideInflate = cubeJson.has("inflate");
        float inflate = JSONUtils.func_151221_a((JsonObject)cubeJson, (String)"inflate", (float)0.0f);
        boolean overrideMirror = cubeJson.has("mirror");
        boolean mirror = JSONUtils.func_151209_a((JsonObject)cubeJson, (String)"mirror", (boolean)false);
        GeometryModelData.CubeUV[] uv = Geometry180Parser.parseUV(cubeJson, size);
        if (uv.length != Direction.values().length) {
            throw new JsonParseException("Expected uv to be of size " + Direction.values().length + ", was " + uv.length);
        }
        return new GeometryModelData.Cube(new Vector3f(origin[0], origin[1], origin[2]), new Vector3f(size[0], size[1], size[2]), new Vector3f(rotation[0], rotation[1], rotation[2]), new Vector3f(pivot[0], pivot[1], pivot[2]), overrideInflate, inflate, overrideMirror, mirror, uv);
    }

    private static GeometryModelData.CubeUV[] parseUV(JsonObject cubeJson, float[] size) {
        if (!cubeJson.has("uv")) {
            return new GeometryModelData.CubeUV[6];
        }
        if (cubeJson.get("uv").isJsonArray()) {
            return Geometry110Parser.parseUV(cubeJson, size);
        }
        if (cubeJson.get("uv").isJsonObject()) {
            JsonObject uvJson = cubeJson.getAsJsonObject("uv");
            GeometryModelData.CubeUV[] uvs = new GeometryModelData.CubeUV[6];
            for (Direction direction : Direction.values()) {
                if (!uvJson.has(direction.func_176742_j())) continue;
                JsonObject faceJson = JSONUtils.func_152754_s((JsonObject)uvJson, (String)direction.func_176742_j());
                float[] uv = JSONTupleParser.getFloat(faceJson, "uv", 2, null);
                float[] uvSize = JSONTupleParser.getFloat(faceJson, "uv_size", 2, () -> new float[2]);
                String material = JSONUtils.func_151219_a((JsonObject)faceJson, (String)"material_instance", (String)"texture");
                uvs[direction.func_176745_a()] = new GeometryModelData.CubeUV(uv[0], uv[1], uvSize[0], uvSize[1], material);
            }
            return uvs;
        }
        throw new JsonSyntaxException("Expected uv to be a JsonArray or JsonObject, was " + JSONUtils.func_151222_d((JsonElement)cubeJson.get("uv")));
    }
}

