/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.mannequins.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.mannequins.client.screen.component.ScrollBar;
import gg.moonflower.mannequins.common.entity.AbstractMannequin;
import gg.moonflower.mannequins.common.menu.MannequinInventoryMenu;
import gg.moonflower.mannequins.common.network.MannequinsMessages;
import gg.moonflower.mannequins.common.network.play.ServerboundSetMannequinPose;
import gg.moonflower.pollen.api.client.util.ScissorHelper;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public abstract class AbstractMannequinScreen
extends ContainerScreen<MannequinInventoryMenu> {
    private static MannequinPart selectedPart = MannequinPart.HEAD;
    private final AbstractMannequin mannequin;
    private ScrollBar xScroll;
    private ScrollBar yScroll;
    private ScrollBar zScroll;

    public AbstractMannequinScreen(MannequinInventoryMenu menu, PlayerInventory inventory, AbstractMannequin mannequin) {
        super((Container)menu, inventory, mannequin.func_145748_c_());
        this.mannequin = mannequin;
        this.field_230711_n_ = false;
        this.field_147000_g = 185;
        this.field_238745_s_ += 20;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.xScroll = new ScrollBar(this.field_147003_i + 136, this.field_147009_r + 20, 8, 65, 360, (ITextComponent)new StringTextComponent("X"));
        this.func_230480_a_(this.xScroll);
        this.yScroll = new ScrollBar(this.field_147003_i + 147, this.field_147009_r + 20, 8, 65, 360, (ITextComponent)new StringTextComponent("Y"));
        this.func_230480_a_(this.yScroll);
        this.zScroll = new ScrollBar(this.field_147003_i + 158, this.field_147009_r + 20, 8, 65, 360, (ITextComponent)new StringTextComponent("Z"));
        this.func_230480_a_(this.zScroll);
        this.xScroll.setScrollSpeed(1.0f);
        this.yScroll.setScrollSpeed(1.0f);
        this.zScroll.setScrollSpeed(1.0f);
        this.updateSliders();
    }

    private void updateSliders() {
        Rotations rotations = selectedPart.getRotation(this.mannequin);
        float rotationX = MathHelper.func_76142_g((float)rotations.func_179415_b()) + 180.0f;
        float rotationY = MathHelper.func_76142_g((float)rotations.func_179416_c()) + 180.0f;
        float rotationZ = MathHelper.func_76142_g((float)rotations.func_179413_d()) + 180.0f;
        if (selectedPart == MannequinPart.LEFT_ARM) {
            rotationZ = 360.0f - rotationZ;
        }
        this.xScroll.setScroll(rotationX % 360.0f / 360.0f * (float)this.xScroll.getMaxScroll());
        this.yScroll.setScroll(rotationY % 360.0f / 360.0f * (float)this.yScroll.getMaxScroll());
        this.zScroll.setScroll(rotationZ % 360.0f / 360.0f * (float)this.zScroll.getMaxScroll());
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        for (MannequinPart part : MannequinPart.values()) {
            if (selectedPart == part || !part.isHovered(mouseX - (double)this.field_147003_i, mouseY - (double)this.field_147009_r)) continue;
            selectedPart = part;
            this.updateSliders();
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int mouseButton) {
        return this.xScroll.func_231048_c_(mouseX, mouseY, mouseButton) || this.yScroll.func_231048_c_(mouseX, mouseY, mouseButton) || this.zScroll.func_231048_c_(mouseX, mouseY, mouseButton) || super.func_231048_c_(mouseX, mouseY, mouseButton);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        for (Widget widget : this.field_230710_m_) {
            if (!(widget instanceof IScreen)) continue;
            ((IScreen)widget).func_231023_e_();
        }
    }

    protected void func_230450_a_(MatrixStack poseStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(this.getTexture());
        this.func_238474_b_(poseStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        for (MannequinPart part : MannequinPart.values()) {
            if (selectedPart == part) continue;
            this.func_238474_b_(poseStack, this.field_147003_i + part.xOffset, this.field_147009_r + part.yOffset, part.isHovered(mouseX - this.field_147003_i, mouseY - this.field_147009_r) ? part.buttonU + part.buttonWidth : part.buttonU, part.buttonV, part.buttonWidth, part.buttonHeight);
        }
        ScissorHelper.push((float)(this.field_147003_i + 26), (float)(this.field_147009_r + 18), (float)49.0f, (float)70.0f);
        InventoryScreen.func_228187_a_((int)(this.field_147003_i + 51), (int)(this.field_147009_r + 80), (int)28, (float)0.0f, (float)-30.0f, (LivingEntity)this.mannequin);
        ScissorHelper.pop();
    }

    public void func_230430_a_(MatrixStack arg, int mouseX, int mouseY, float partialTicks) {
        partialTicks = Minecraft.func_71410_x().func_184121_ak();
        this.func_230446_a_(arg);
        super.func_230430_a_(arg, mouseX, mouseY, partialTicks);
        this.func_230459_a_(arg, mouseX, mouseY);
        Rotations rotations = selectedPart.getRotation(this.mannequin);
        float x = this.xScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        float y = this.yScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        float z = this.zScroll.getInterpolatedScrollPercentage(partialTicks) * 360.0f - 180.0f;
        if (selectedPart == MannequinPart.LEFT_ARM) {
            z *= -1.0f;
        }
        if (rotations.func_179415_b() != x || rotations.func_179416_c() != y || rotations.func_179413_d() != z) {
            selectedPart.setRotation(this.mannequin, new Rotations(x, y, z));
        }
    }

    public void func_231175_as__() {
        MannequinsMessages.PLAY.sendToServer((PollinatedPacket)new ServerboundSetMannequinPose(((MannequinInventoryMenu)this.field_147002_h).field_75152_c, this.mannequin.getHeadPose(), this.mannequin.getBodyPose(), this.mannequin.getLeftArmPose(), this.mannequin.getRightArmPose()));
        super.func_231175_as__();
    }

    public abstract ResourceLocation getTexture();

    static enum MannequinPart {
        HEAD(AbstractMannequin::setHeadPose, AbstractMannequin::getHeadPose, 98, 21, 176, 59, 16, 16),
        CHEST(AbstractMannequin::setBodyPose, AbstractMannequin::getBodyPose, 98, 37, 176, 39, 16, 20),
        LEFT_ARM(AbstractMannequin::setLeftArmPose, AbstractMannequin::getLeftArmPose, 114, 37, 176, 15, 8, 24),
        RIGHT_ARM(AbstractMannequin::setRightArmPose, AbstractMannequin::getRightArmPose, 90, 37, 176, 15, 8, 24);

        private final BiConsumer<AbstractMannequin, Rotations> rotationSetter;
        private final Function<AbstractMannequin, Rotations> rotationGetter;
        private final int xOffset;
        private final int yOffset;
        private final int buttonU;
        private final int buttonV;
        private final int buttonWidth;
        private final int buttonHeight;

        private MannequinPart(BiConsumer<AbstractMannequin, Rotations> rotationSetter, Function<AbstractMannequin, Rotations> rotationGetter, int xOffset, int yOffset, int buttonU, int buttonV, int buttonWidth, int buttonHeight) {
            this.rotationSetter = rotationSetter;
            this.rotationGetter = rotationGetter;
            this.xOffset = xOffset;
            this.yOffset = yOffset;
            this.buttonU = buttonU;
            this.buttonV = buttonV;
            this.buttonWidth = buttonWidth;
            this.buttonHeight = buttonHeight;
        }

        public boolean isHovered(double mouseX, double mouseY) {
            return mouseX >= (double)this.xOffset && mouseX < (double)(this.xOffset + this.buttonWidth) && mouseY >= (double)this.yOffset && mouseY < (double)(this.yOffset + this.buttonHeight);
        }

        public Rotations getRotation(AbstractMannequin mannequin) {
            return this.rotationGetter.apply(mannequin);
        }

        public void setRotation(AbstractMannequin mannequin, Rotations rot) {
            this.rotationSetter.accept(mannequin, rot);
        }
    }
}

