/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.mannequins.client.screen.component;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import gg.moonflower.pollen.api.client.render.ShapeRenderer;
import gg.moonflower.pollen.api.util.ScrollHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.screen.IScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class ScrollBar
extends Widget
implements IScreen {
    public static final ResourceLocation TEXTURE = new ResourceLocation("mannequins", "textures/gui/container/scrollbar.png");
    private final ScrollHandler scrollHandler;
    private boolean dragging;

    public ScrollBar(int x, int y, int width, int height, int maxScroll, ITextComponent title) {
        super(x, y, width, height, title);
        this.scrollHandler = new ScrollHandler(0, height);
        this.setMaxScroll(maxScroll);
        this.dragging = false;
    }

    public void func_231023_e_() {
        this.scrollHandler.update();
    }

    public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        boolean draggable;
        Minecraft minecraft = Minecraft.func_71410_x();
        minecraft.func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_230695_q_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.func_230441_a_(poseStack, minecraft, mouseX, mouseY);
        boolean bl = draggable = this.scrollHandler.getMaxScroll() > 0;
        if (this.dragging) {
            this.scrollHandler.setScroll((double)this.scrollHandler.getMaxScroll() * ((double)((float)(mouseY - this.field_230691_m_) - 7.5f) / (double)(this.field_230689_k_ - 15)));
        }
        float barY = draggable ? (float)(this.field_230689_k_ - 17) * this.scrollHandler.getInterpolatedScroll(partialTicks) / (float)this.scrollHandler.getMaxScroll() : 0.0f;
        ShapeRenderer.drawRectWithTexture((MatrixStack)poseStack, (float)(this.field_230690_l_ + 1), (float)(this.field_230691_m_ + Math.round(barY) + 1), (float)(draggable ? 0.0f : 6.0f), (float)0.0f, (float)6.0f, (float)15.0f, (float)6.0f, (float)15.0f, (float)16.0f, (float)16.0f);
    }

    public void func_230988_a_(SoundHandler manager) {
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.dragging = true;
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.dragging = false;
            return true;
        }
        return false;
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        this.scrollHandler.mouseScrolled(2.0, delta);
        return true;
    }

    public void setScrollSpeed(float speed) {
        this.scrollHandler.setScrollSpeed(speed);
    }

    public float getInterpolatedScrollPercentage(float partialTicks) {
        return this.scrollHandler.getMaxScroll() > 0 ? this.scrollHandler.getInterpolatedScroll(partialTicks) / (float)this.scrollHandler.getMaxScroll() : 0.0f;
    }

    public float getScrollPercentage() {
        return this.scrollHandler.getMaxScroll() > 0 ? (float)(this.scrollHandler.getScroll() / (double)this.scrollHandler.getMaxScroll()) : 0.0f;
    }

    public double getScroll() {
        return this.scrollHandler.getMaxScroll() > 0 ? this.scrollHandler.getScroll() : 0.0;
    }

    public void setScroll(double scroll) {
        this.scrollHandler.setScroll(scroll);
    }

    public float getInterpolatedScroll(float partialTicks) {
        return this.scrollHandler.getMaxScroll() > 0 ? this.scrollHandler.getInterpolatedScroll(partialTicks) : 0.0f;
    }

    public int getMaxScroll() {
        return this.scrollHandler.getMaxScroll();
    }

    public void setMaxScroll(int maxScroll) {
        this.scrollHandler.setHeight(maxScroll);
    }
}

