/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.mannequins.common.entity;

import gg.moonflower.mannequins.client.screen.AbstractMannequinScreen;
import gg.moonflower.mannequins.client.screen.MannequinScreen;
import gg.moonflower.mannequins.common.entity.AbstractMannequin;
import gg.moonflower.mannequins.common.menu.MannequinInventoryMenu;
import gg.moonflower.mannequins.core.registry.MannequinsItems;
import gg.moonflower.mannequins.core.registry.MannequinsSounds;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Mannequin
extends AbstractMannequin {
    private float attackAnimationXFactor;
    private float attackAnimationZFactor;
    private int attackAnimation;

    public Mannequin(EntityType<? extends AbstractMannequin> type, World level) {
        super(type, level);
    }

    @Override
    public void onAttack(float attackYaw) {
        float rotation = attackYaw - (float)((double)this.field_70761_aq / 180.0 * Math.PI);
        this.field_70739_aP = attackYaw;
        this.attackAnimation = 40;
        this.attackAnimationXFactor = MathHelper.func_76134_b((float)rotation);
        this.attackAnimationZFactor = MathHelper.func_76126_a((float)rotation);
    }

    @Override
    public boolean canChangeExpression(PlayerEntity player, Hand hand) {
        return player.func_184586_b(hand).func_77973_b() instanceof AxeItem;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.func_201670_d()) {
            if (this.attackAnimation <= 0) {
                return;
            }
            --this.attackAnimation;
        }
    }

    @Override
    public ItemStack getItem() {
        return new ItemStack((IItemProvider)MannequinsItems.MANNEQUIN.get());
    }

    @Override
    public IParticleData getParticle() {
        return new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196662_n.func_176223_P());
    }

    @Override
    public SoundEvent getHitSound() {
        return MannequinsSounds.ENTITY_MANNEQUIN_HIT.get();
    }

    @Override
    public SoundEvent getBrokenSound() {
        return MannequinsSounds.ENTITY_MANNEQUIN_BREAK.get();
    }

    @Override
    public SoundEvent getPlaceSound() {
        return MannequinsSounds.ENTITY_MANNEQUIN_PLACE.get();
    }

    protected SoundEvent func_184588_d(int height) {
        return MannequinsSounds.ENTITY_MANNEQUIN_FALL.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AbstractMannequinScreen getScreen(MannequinInventoryMenu menu, PlayerInventory inventory) {
        return new MannequinScreen(menu, inventory, this);
    }

    private float getAttackAnimation(float partialTicks) {
        float x = (float)this.attackAnimation - partialTicks;
        return MathHelper.func_76134_b((float)x) / 2.0f * MathHelper.func_76129_c((float)x) / (50.0f - x);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasAnimation() {
        return this.attackAnimation > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationRotationX(float partialTicks) {
        return this.attackAnimationXFactor * this.getAttackAnimation(partialTicks);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getAnimationRotationZ(float partialTicks) {
        return this.attackAnimationZFactor * this.getAttackAnimation(partialTicks);
    }
}

