/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.mannequins.core;

import gg.moonflower.mannequins.client.render.entity.MannequinRenderer;
import gg.moonflower.mannequins.client.render.entity.StatueRenderer;
import gg.moonflower.mannequins.common.entity.AbstractMannequin;
import gg.moonflower.mannequins.common.network.MannequinsMessages;
import gg.moonflower.mannequins.common.network.play.ClientboundAttackMannequin;
import gg.moonflower.mannequins.core.registry.MannequinsEntities;
import gg.moonflower.mannequins.core.registry.MannequinsItems;
import gg.moonflower.mannequins.core.registry.MannequinsSounds;
import gg.moonflower.pollen.api.event.events.entity.player.PlayerInteractionEvents;
import gg.moonflower.pollen.api.event.events.registry.client.RegisterAtlasSpriteEvent;
import gg.moonflower.pollen.api.network.packet.PollinatedPacket;
import gg.moonflower.pollen.api.platform.Platform;
import gg.moonflower.pollen.api.registry.EntityAttributeRegistry;
import gg.moonflower.pollen.api.registry.client.EntityRendererRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.FishingRodItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class Mannequins {
    public static final String MOD_ID = "mannequins";
    public static final Platform PLATFORM = Platform.builder((String)"mannequins").commonInit(Mannequins::commonInit).commonPostInit(Mannequins::commonPostInit).clientInit(Mannequins::clientInit).clientPostInit(Mannequins::clientPostInit).build();

    public static void commonInit() {
        MannequinsSounds.SOUNDS.register(PLATFORM);
        MannequinsItems.ITEMS.register(PLATFORM);
        MannequinsEntities.ENTITIES.register(PLATFORM);
        MannequinsMessages.init();
        EntityAttributeRegistry.register(MannequinsEntities.MANNEQUIN, () -> AbstractMannequin.func_233639_cI_().func_233815_a_(Attributes.field_233820_c_, 1.0));
        EntityAttributeRegistry.register(MannequinsEntities.STATUE, () -> AbstractMannequin.func_233639_cI_().func_233815_a_(Attributes.field_233820_c_, 1.0));
        PlayerInteractionEvents.RIGHT_CLICK_ITEM.register((player, level, hand) -> {
            ItemStack stack = player.func_184586_b(hand);
            if (player.field_70170_p.func_201670_d()) {
                return ActionResult.func_226250_c_((Object)stack);
            }
            if (player.field_71104_cf == null || !(stack.func_77973_b() instanceof FishingRodItem)) {
                return ActionResult.func_226250_c_((Object)stack);
            }
            Entity hooked = player.field_71104_cf.func_234607_k_();
            if (hooked instanceof AbstractMannequin) {
                MannequinsMessages.PLAY.sendToTracking(hooked, (PollinatedPacket)new ClientboundAttackMannequin(hooked.func_145782_y(), (float)(Math.PI - MathHelper.func_181159_b((double)(player.func_226277_ct_() - hooked.func_226277_ct_()), (double)(player.func_226281_cx_() - hooked.func_226281_cx_())))));
            }
            return ActionResult.func_226250_c_((Object)stack);
        });
    }

    public static void clientInit() {
        RegisterAtlasSpriteEvent.event((ResourceLocation)PlayerContainer.field_226615_c_).register((atlas, registry) -> registry.accept(new ResourceLocation(MOD_ID, "item/empty_mannequin_slot_mainhand")));
    }

    public static void commonPostInit(Platform.ModSetupContext ctx) {
    }

    public static void clientPostInit(Platform.ModSetupContext ctx) {
        EntityRendererRegistry.register(MannequinsEntities.MANNEQUIN, context -> new MannequinRenderer(context.getEntityRenderDispatcher()));
        EntityRendererRegistry.register(MannequinsEntities.STATUE, context -> new StatueRenderer(context.getEntityRenderDispatcher()));
    }
}

