/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.effects.BlockEffect;
import org.orecruncher.environs.effects.BubbleJetEffect;
import org.orecruncher.environs.effects.DustJetEffect;
import org.orecruncher.environs.effects.FireFlyEffect;
import org.orecruncher.environs.effects.FireJetEffect;
import org.orecruncher.environs.effects.FountainJetEffect;
import org.orecruncher.environs.effects.SteamJetEffect;
import org.orecruncher.environs.effects.WaterfallSplashEffect;

@OnlyIn(value=Dist.CLIENT)
public enum BlockEffectType {
    UNKNOWN("UNKNOWN", ignored -> null, () -> false),
    FIREFLY("firefly", FireFlyEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableFireFlies).get()),
    STEAM("steam", SteamJetEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableSteamJets).get()),
    FIRE("fire", FireJetEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableFireJets).get()),
    BUBBLE("bubble", BubbleJetEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableBubbleJets).get()),
    DUST("dust", DustJetEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableDustJets).get()),
    FOUNTAIN("fountain", FountainJetEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableFountainJets).get()),
    SPLASH("splash", WaterfallSplashEffect::new, () -> ((ForgeConfigSpec.BooleanValue)Config.CLIENT.effects.enableWaterfalls).get());

    private static final Map<String, BlockEffectType> typeMap;
    protected final String name;
    protected final Function<Integer, BlockEffect> factory;
    protected final Supplier<Boolean> enabled;

    @Nonnull
    public static BlockEffectType get(@Nonnull String name) {
        BlockEffectType result = typeMap.get(name);
        return result == null ? UNKNOWN : result;
    }

    private BlockEffectType(@Nonnull String name, Function<Integer, BlockEffect> factory, Supplier<Boolean> enabled) {
        this.name = name;
        this.enabled = enabled;
        this.factory = factory;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Nonnull
    public Optional<BlockEffect> getInstance(int chance) {
        return Optional.ofNullable(this.factory.apply(chance));
    }

    static {
        typeMap = new Object2ObjectOpenHashMap();
        for (BlockEffectType effect : BlockEffectType.values()) {
            typeMap.put(effect.getName(), effect);
        }
    }
}

