/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.effects;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.environs.effects.BlockEffectType;
import org.orecruncher.environs.effects.JetEffect;
import org.orecruncher.environs.effects.emitters.BubbleJet;

@OnlyIn(value=Dist.CLIENT)
public class BubbleJetEffect
extends JetEffect {
    public BubbleJetEffect(int chance) {
        super(chance);
    }

    @Override
    @Nonnull
    public BlockEffectType getEffectType() {
        return BlockEffectType.BUBBLE;
    }

    @Override
    public boolean canTrigger(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        if (WATER_PREDICATE.test(state)) {
            BlockState belowBlock = provider.func_180495_p(pos.func_177977_b());
            Material material = belowBlock.func_185904_a();
            boolean isSolidBlock = material.func_76220_a();
            if (isSolidBlock) {
                boolean bl = false;
            }
            return isSolidBlock && super.canTrigger(provider, state, pos, random);
        }
        return false;
    }

    @Override
    public void doEffect(@Nonnull IBlockReader provider, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull Random random) {
        int liquidBlocks = BubbleJetEffect.countVerticalBlocks(provider, pos, WATER_PREDICATE, 1);
        if (liquidBlocks > 0) {
            BubbleJet effect = new BubbleJet(liquidBlocks, provider, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.1, (double)pos.func_177952_p() + 0.5);
            this.addEffect(effect);
        }
    }
}

