/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.handlers;

import com.mojang.blaze3d.platform.GlStateManager;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.profiler.IProfiler;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.BedrockFogRangeCalculator;
import org.orecruncher.environs.fog.BiomeFogRangeCalculator;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.HazeFogRangeCalculator;
import org.orecruncher.environs.fog.HolisticFogRangeCalculator;
import org.orecruncher.environs.fog.MorningFogRangeCalculator;
import org.orecruncher.environs.fog.WeatherFogRangeCalculator;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.handlers.HandlerBase;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.events.DiagnosticEvent;
import org.orecruncher.lib.math.LoggingTimerEMA;

@OnlyIn(value=Dist.CLIENT)
public class FogHandler
extends HandlerBase {
    protected final LoggingTimerEMA render = new LoggingTimerEMA("Render Fog");
    protected HolisticFogRangeCalculator fogRange = new HolisticFogRangeCalculator();

    public FogHandler() {
        super("Fog Handler");
    }

    public static boolean doFog() {
        return (Boolean)Config.CLIENT.fog.enableFog.get() != false && CommonState.getDimensionInfo().hasFog();
    }

    @Override
    public void process(@Nonnull PlayerEntity player) {
        if (FogHandler.doFog()) {
            this.fogRange.tick();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void fogRenderEvent(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.getType() == FogRenderer.FogType.FOG_TERRAIN && FogHandler.doFog()) {
            IProfiler profiler = GameUtils.getMC().func_213239_aq();
            profiler.func_76320_a("Environs Fog Render");
            this.render.begin();
            FluidState fluidState = event.getInfo().func_216771_k();
            if (fluidState.func_206888_e()) {
                FogResult result = this.fogRange.calculate(event);
                GlStateManager.func_227671_b_((float)result.getStart());
                GlStateManager.func_227687_c_((float)result.getEnd());
            }
            this.render.end();
            profiler.func_76319_b();
        }
    }

    @SubscribeEvent
    public void diagnostics(DiagnosticEvent event) {
        if (((Boolean)Config.CLIENT.logging.enableLogging.get()).booleanValue()) {
            if (FogHandler.doFog()) {
                event.getLeft().add("Fog Range: " + this.fogRange.toString());
                event.addRenderTimer(this.render);
            } else {
                event.getLeft().add("FOG: IGNORED");
            }
        }
    }

    @Override
    public void onConnect() {
        this.fogRange = new HolisticFogRangeCalculator();
        this.fogRange.add(new BiomeFogRangeCalculator());
        this.fogRange.add(new HazeFogRangeCalculator());
        this.fogRange.add(new MorningFogRangeCalculator());
        this.fogRange.add(new BedrockFogRangeCalculator());
        this.fogRange.add(new WeatherFogRangeCalculator());
    }
}

