/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.scanner;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.logging.IModLog;

@OnlyIn(value=Dist.CLIENT)
public class ScanContext {
    private final Supplier<IBlockReader> worldReader;
    private final Supplier<BlockPos> scanCenter;
    private final Supplier<Integer> worldReference;
    private final Supplier<IModLog> logger;

    public ScanContext(@Nonnull Supplier<IBlockReader> worldReader, @Nonnull Supplier<BlockPos> scanCenter, @Nonnull Supplier<IModLog> logger, @Nonnull Supplier<Integer> worldReference) {
        this.worldReader = worldReader;
        this.scanCenter = scanCenter;
        this.worldReference = worldReference;
        this.logger = logger;
    }

    @Nonnull
    public IBlockReader getWorld() {
        return this.worldReader.get();
    }

    @Nonnull
    public BlockPos getCenter() {
        return this.scanCenter.get();
    }

    @Nonnull
    public IModLog getLogger() {
        return this.logger.get();
    }

    public int getReference() {
        return this.worldReference.get();
    }
}

