/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.math;

import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import org.orecruncher.lib.math.BlockRayTrace;
import org.orecruncher.lib.math.MathStuff;

public class RayTraceIterator
implements Iterator<BlockRayTraceResult> {
    @Nonnull
    private final BlockRayTrace traceContext;
    @Nonnull
    private final BlockPos targetBlock;
    @Nonnull
    private final Vector3d normal;
    @Nullable
    private BlockRayTraceResult hitResult;

    public RayTraceIterator(@Nonnull BlockRayTrace traceContext) {
        this.traceContext = traceContext;
        this.targetBlock = new BlockPos(traceContext.end);
        this.normal = MathStuff.normalize(traceContext.start, traceContext.end);
        this.doTrace();
    }

    private void doTrace() {
        this.hitResult = this.hitResult != null && this.hitResult.func_216350_a().equals((Object)this.targetBlock) ? null : this.traceContext.trace();
    }

    @Override
    public boolean hasNext() {
        return this.hitResult != null && this.hitResult.func_216346_c() != RayTraceResult.Type.MISS;
    }

    @Override
    @Nonnull
    public BlockRayTraceResult next() {
        if (this.hitResult == null || this.hitResult.func_216346_c() == RayTraceResult.Type.MISS) {
            throw new IllegalStateException("No more blocks in trace");
        }
        BlockRayTraceResult result = this.hitResult;
        this.traceContext.start = this.hitResult.func_216347_e().func_178787_e(this.normal);
        this.doTrace();
        return result;
    }
}

