/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.shaders;

import com.mojang.blaze3d.platform.GlStateManager;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.client.shader.IShaderManager;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Lib;

@OnlyIn(value=Dist.CLIENT)
final class ShaderProgram
implements IShaderManager {
    private final String name;
    private final int program;
    private final ShaderLoader vert;
    private final ShaderLoader frag;
    private final Object2IntOpenHashMap<String> uniforms = new Object2IntOpenHashMap();

    ShaderProgram(@Nonnull String name, int program, @Nonnull ShaderLoader vert, @Nonnull ShaderLoader frag) {
        this.name = name;
        this.program = program;
        this.vert = vert;
        this.frag = frag;
        this.uniforms.defaultReturnValue(-1);
    }

    public int func_147986_h() {
        return this.program;
    }

    void setUniforms(@Nonnull Collection<String> uniforms) {
        for (String u : uniforms) {
            int id = GlStateManager.func_227680_b_((int)this.program, (CharSequence)u);
            if (id < 0) {
                Lib.LOGGER.warn("Cannot locate uniform '%s' for shader '%s'", u, this.name);
            }
            this.uniforms.put((Object)u, id);
        }
    }

    int getUniform(@Nonnull String uniform) {
        return this.uniforms.getInt((Object)uniform);
    }

    public void func_147985_d() {
    }

    @Nonnull
    public ShaderLoader func_147989_e() {
        return this.vert;
    }

    @Nonnull
    public ShaderLoader func_147994_f() {
        return this.frag;
    }

    public String toString() {
        return String.format("%s [%d]", this.name, this.program);
    }
}

