/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.acoustic;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.sndctrl.api.acoustics.IAcousticFactory;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.api.sound.IFadableSoundInstance;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.api.sound.ISoundInstance;
import org.orecruncher.sndctrl.api.sound.SoundBuilder;
import org.orecruncher.sndctrl.audio.BackgroundSoundInstance;
import org.orecruncher.sndctrl.audio.EntitySoundInstance;
import org.orecruncher.sndctrl.audio.SoundInstance;

@OnlyIn(value=Dist.CLIENT)
public class AcousticFactory
extends SoundBuilder
implements IAcousticFactory {
    public static final int SOUND_RANGE = 16;
    private static final Random RANDOM = new XorShiftRandom();

    public AcousticFactory(@Nonnull SoundEvent event) {
        super(event, Category.AMBIENT);
    }

    public AcousticFactory(@Nonnull SoundEvent event, @Nonnull ISoundCategory category) {
        super(event, category);
    }

    private static Vector3d randomPoint(int minRange, int maxRange) {
        double x = RANDOM.nextDouble() - 0.5;
        double y = RANDOM.nextDouble() - 0.5;
        double z = RANDOM.nextDouble() - 0.5;
        Vector3d vec = new Vector3d(x, y, z).func_72432_b();
        int range = maxRange - minRange;
        double magnitude = range <= 0 ? (double)minRange : (double)minRange + RANDOM.nextDouble() * (double)range;
        return vec.func_186678_a(magnitude);
    }

    @Override
    @Nonnull
    public ISoundInstance createSound() {
        return this.createSoundAt(BlockPos.field_177992_a);
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundAt(@Nonnull BlockPos pos) {
        SoundInstance sound = this.makeSound();
        sound.setPosition((Vector3i)pos);
        return sound;
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundAt(@Nonnull Vector3d pos) {
        SoundInstance sound = this.makeSound();
        sound.setPosition(pos);
        return sound;
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundNear(@Nonnull Entity entity) {
        return this.createSoundNear(entity, 0, 16);
    }

    @Override
    @Nonnull
    public ISoundInstance createSoundNear(@Nonnull Entity entity, int minRange, int maxRange) {
        Vector3d offset = AcousticFactory.randomPoint(minRange, maxRange);
        float posX = (float)(entity.func_226277_ct_() + offset.func_82615_a());
        float posY = (float)(entity.func_226278_cu_() + (double)entity.func_70047_e() + offset.func_82617_b());
        float posZ = (float)(entity.func_226281_cx_() + offset.func_82616_c());
        SoundInstance sound = this.makeSound();
        sound.setPosition(posX, posY, posZ);
        return sound;
    }

    @Override
    @Nonnull
    public ISoundInstance attachSound(@Nonnull Entity entity) {
        return new EntitySoundInstance(entity, this.makeSound());
    }

    @Override
    @Nonnull
    public IFadableSoundInstance createBackgroundSound() {
        return new BackgroundSoundInstance(this.createSound());
    }
}

