/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.library;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.SoundTypeUtils;
import org.orecruncher.lib.Utilities;
import org.orecruncher.lib.resource.ResourceUtils;
import org.orecruncher.mobeffects.library.Constants;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.sound.ISoundCategory;
import org.orecruncher.sndctrl.audio.acoustic.AcousticCompiler;
import org.orecruncher.sndctrl.audio.acoustic.NullAcoustic;
import org.orecruncher.sndctrl.audio.acoustic.SimpleAcoustic;
import org.orecruncher.sndctrl.library.AcousticLibrary;
import org.orecruncher.sndctrl.library.SoundLibrary;

@OnlyIn(value=Dist.CLIENT)
public class Primitives {
    private static final float MINECRAFT_VOLUME_SCALE = 0.15f;
    private static final String ARMOR_EQUIP_PREFIX = "primitive/armor/equip/";
    private static final String ARMOR_ACCENT_PREFIX = "primitive/armor/accent/";
    private static final String FOOTSTEP_PREFIX = "primitive/block/step/";
    private static final String VANILLA_FOOTSTEP_PREFIX = "primitive/block/step/vanilla/";
    private static final String SOUND_PREFIX = "primitive/sound/";
    private static final ResourceLocation ARMOR_TEMPLATE = new ResourceLocation("sndctrl", "templates/primitive_armor_accent.json");
    private static final ResourceLocation FOOTSTEP_TEMPLATE = new ResourceLocation("sndctrl", "templates/primitive_block_step.json");

    @Nonnull
    public static ResourceLocation createArmorToolbarResource(@Nonnull IArmorMaterial material) {
        return new ResourceLocation("mobeffects", Utilities.safeResourcePath(ARMOR_EQUIP_PREFIX + material.func_200897_d()));
    }

    @Nonnull
    public static ResourceLocation createArmorAccentResource(@Nonnull IArmorMaterial material) {
        return new ResourceLocation("mobeffects", Utilities.safeResourcePath(ARMOR_ACCENT_PREFIX + material.func_200897_d()));
    }

    @Nonnull
    public static ResourceLocation createFootstepResource(@Nonnull SoundType st) {
        return Primitives.createFootstepResource(SoundTypeUtils.getSoundTypeName(st));
    }

    @Nonnull
    public static ResourceLocation createVanillaFootstepResource(@Nonnull SoundType st) {
        String safePath = Utilities.safeResourcePath(VANILLA_FOOTSTEP_PREFIX + SoundTypeUtils.getSoundTypeName(st));
        return new ResourceLocation("mobeffects", safePath);
    }

    @Nonnull
    public static ResourceLocation createFootstepResource(@Nonnull String soundType) {
        String safePath = Utilities.safeResourcePath(FOOTSTEP_PREFIX + soundType);
        return new ResourceLocation("mobeffects", safePath);
    }

    @Nonnull
    private static ResourceLocation createSoundLocation(@Nonnull ResourceLocation loc, @Nonnull ISoundCategory category) {
        String safePath = Utilities.safeResourcePath(SOUND_PREFIX + category.getName() + "/" + loc.toString());
        return new ResourceLocation("mobeffects", safePath);
    }

    @Nonnull
    public static IAcoustic getSound(@Nonnull ResourceLocation loc, @Nonnull ISoundCategory category) {
        Optional<SoundEvent> se;
        ResourceLocation resource = Primitives.createSoundLocation(loc, category);
        IAcoustic acoustic = AcousticLibrary.resolve(resource);
        if (acoustic == NullAcoustic.INSTANCE && (se = SoundLibrary.getSound(loc)).isPresent() && se.get() != SoundLibrary.MISSING) {
            acoustic = new SimpleAcoustic(se.get(), category);
            AcousticLibrary.addAcoustic(resource, acoustic);
        }
        return acoustic;
    }

    @Nonnull
    public static IAcoustic getArmorToolbarAcoustic(@Nonnull IArmorMaterial material) {
        SoundEvent event;
        ResourceLocation loc = Primitives.createArmorToolbarResource(material);
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isValid(event = material.func_200899_b())) {
            acoustic = new SimpleAcoustic(event, Constants.TOOLBAR);
            AcousticLibrary.addAcoustic(loc, acoustic);
        }
        return acoustic;
    }

    @Nonnull
    public static IAcoustic getArmorAccentAcoustic(@Nonnull IArmorMaterial material) {
        SoundEvent event;
        ResourceLocation loc = Primitives.createArmorAccentResource(material);
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isValid(event = material.func_200899_b())) {
            acoustic = Primitives.generateAcousticFromTemplate(ARMOR_TEMPLATE, loc, event.func_187503_a());
            AcousticLibrary.addAcoustic(loc, acoustic);
            return acoustic;
        }
        return Primitives.footstepAcousticResolver(loc, material.func_200899_b());
    }

    @Nonnull
    public static IAcoustic getFootstepAcoustic(@Nonnull BlockState state) {
        return Primitives.getFootstepAcoustic(state.func_215695_r());
    }

    @Nonnull
    public static IAcoustic getVanillaFootstepAcoustic(@Nonnull SoundType soundType) {
        ResourceLocation loc = Primitives.createVanillaFootstepResource(soundType);
        return Primitives.footstepAcousticResolver(loc, soundType, true);
    }

    @Nonnull
    public static IAcoustic getFootstepAcoustic(@Nonnull SoundType soundType) {
        ResourceLocation loc = Primitives.createFootstepResource(soundType);
        return Primitives.footstepAcousticResolver(loc, soundType, false);
    }

    @Nonnull
    private static IAcoustic footstepAcousticResolver(@Nonnull ResourceLocation loc, @Nonnull SoundEvent soundType) {
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isValid(soundType)) {
            SimpleAcoustic simple = new SimpleAcoustic(soundType, Constants.FOOTSTEPS);
            simple.getFactory().setVolume(0.375f);
            AcousticLibrary.addAcoustic(loc, simple);
            acoustic = simple;
        }
        return acoustic;
    }

    @Nonnull
    private static IAcoustic footstepAcousticResolver(@Nonnull ResourceLocation loc, @Nonnull SoundType soundType, boolean isVanilla) {
        IAcoustic acoustic = AcousticLibrary.resolve(loc);
        if (acoustic == NullAcoustic.INSTANCE && SoundTypeUtils.isStepSoundValid(soundType)) {
            if (isVanilla) {
                SimpleAcoustic simple = new SimpleAcoustic(soundType.func_185844_d(), Constants.FOOTSTEPS);
                simple.getFactory().setVolume(soundType.func_185843_a() * 0.375f);
                simple.getFactory().setPitch(soundType.func_185847_b());
                AcousticLibrary.addAcoustic(loc, simple);
                acoustic = simple;
            } else {
                acoustic = Primitives.generateAcousticFromTemplate(FOOTSTEP_TEMPLATE, loc, soundType.func_185844_d().func_187503_a());
            }
        }
        return acoustic;
    }

    private static IAcoustic generateAcousticFromTemplate(@Nonnull ResourceLocation template, @Nonnull ResourceLocation name, @Nonnull ResourceLocation acousticName) {
        try {
            String jsonResource = ResourceUtils.readResource(template);
            if (jsonResource != null) {
                jsonResource = jsonResource.replaceAll("<NAME>", name.toString()).replaceAll("<ACOUSTIC>", acousticName.toString());
                List<IAcoustic> acoustic = new AcousticCompiler("mobeffects").compile(jsonResource);
                return acoustic.get(0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return NullAcoustic.INSTANCE;
    }
}

