/*
 * Decompiled with CFR 0.152.
 */
package dzwdz.chat_heads;

import dzwdz.chat_heads.config.ChatHeadsConfig;
import dzwdz.chat_heads.config.ChatHeadsConfigDefaults;
import dzwdz.chat_heads.mixinterface.GuiMessageOwnerAccessor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChatHeads {
    public static final String MOD_ID = "chat_heads";
    public static ChatHeadsConfig CONFIG = new ChatHeadsConfigDefaults();
    @Nullable
    public static NetworkPlayerInfo lastSender;
    @Nullable
    public static ChatLine<?> lastGuiMessage;
    public static int lastY;
    public static float lastOpacity;
    public static int lastChatOffset;
    public static boolean serverSentUuid;

    public static int getChatOffset(@NotNull ChatLine<?> guiMessage) {
        NetworkPlayerInfo owner = ((GuiMessageOwnerAccessor)guiMessage).chatheads$getOwner();
        return ChatHeads.getChatOffset(owner);
    }

    public static int getChatOffset(@Nullable NetworkPlayerInfo owner) {
        if (owner != null || CONFIG.offsetNonPlayerText()) {
            return 10;
        }
        return 0;
    }

    @Nullable
    public static NetworkPlayerInfo detectPlayer(ClientPlayNetHandler connection, ITextComponent message) {
        HashMap<String, NetworkPlayerInfo> nicknameCache = new HashMap<String, NetworkPlayerInfo>();
        for (String word : message.getString().split("(\u00a7.)|[^\\w]")) {
            if (word.isEmpty()) continue;
            NetworkPlayerInfo player = connection.func_175104_a(word);
            if (player != null) {
                return player;
            }
            player = ChatHeads.getPlayerFromNickname(word, connection, nicknameCache);
            if (player == null) continue;
            return player;
        }
        return null;
    }

    @Nullable
    private static NetworkPlayerInfo getPlayerFromNickname(String word, ClientPlayNetHandler connection, Map<String, NetworkPlayerInfo> nicknameCache) {
        if (nicknameCache.isEmpty()) {
            for (NetworkPlayerInfo p : connection.func_175106_d()) {
                ITextComponent displayName = p.func_178854_k();
                if (displayName == null) continue;
                String nickname = displayName.getString();
                if (word.equals(nickname)) {
                    nicknameCache.clear();
                    return p;
                }
                nicknameCache.put(nickname, p);
            }
        } else {
            return nicknameCache.get(word);
        }
        return null;
    }

    static {
        lastY = 0;
        lastOpacity = 0.0f;
        serverSentUuid = false;
    }
}

