/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import java.nio.file.Path;
import net.minecraftforge.common.ForgeConfigSpec;

public class Configuration {
    private final ForgeConfigSpec spec;
    private final ForgeConfigSpec.BooleanValue loadDataPacks;
    private final ForgeConfigSpec.BooleanValue loadResourcePacks;

    public Configuration() {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        builder.comment("Advanced Settings: Only edit these if you know what you're doing!");
        builder.comment("This file is NOT used to add new data/resource packs. Just put them in the folder!");
        builder.push("advanced-settings");
        builder.comment("Should OpenLoader try to load resource packs?");
        this.loadResourcePacks = builder.define("load-resource-packs", true);
        builder.comment("Should OpenLoader try to load data packs?");
        this.loadDataPacks = builder.define("load-data-packs", true);
        builder.pop();
        this.spec = builder.build();
    }

    public ForgeConfigSpec getSpec() {
        return this.spec;
    }

    public boolean allowDataPacks() {
        return (Boolean)this.loadDataPacks.get();
    }

    public boolean allowResourcePacks() {
        return (Boolean)this.loadResourcePacks.get();
    }

    public void forceLoad(Path path) {
        CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder((Path)path).sync().autosave().writingMode(WritingMode.REPLACE).build();
        configData.load();
        this.spec.setConfig((CommentedConfig)configData);
    }
}

