/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.darkhax.openloader.OpenLoader;
import net.darkhax.openloader.OpenLoaderPackFinder;

public class DataCache {
    @Expose
    public Set<String> cachedResourcePacks = new HashSet<String>();
    private static final Gson GSON = new GsonBuilder().create();
    private static final File path = new File("openloader", ".cache");

    public void save() {
        DataCache.init();
        try (FileWriter writer = new FileWriter(path);){
            GSON.toJson((Object)this, (Appendable)writer);
            OpenLoader.LOGGER.debug("Saved cache.");
        }
        catch (IOException e) {
            OpenLoader.LOGGER.error("Could not write cache file!", (Throwable)e);
        }
    }

    public void cache(OpenLoaderPackFinder.Type type, String name) {
        if (type == OpenLoaderPackFinder.Type.RESOURCES) {
            this.cachedResourcePacks.add(name);
        }
    }

    public boolean isCached(OpenLoaderPackFinder.Type type, String name) {
        if (type == OpenLoaderPackFinder.Type.RESOURCES) {
            return this.cachedResourcePacks.contains(name);
        }
        return false;
    }

    public static void init() {
        try {
            if (!path.exists()) {
                path.getParentFile().mkdirs();
                path.createNewFile();
            }
        }
        catch (IOException e) {
            OpenLoader.LOGGER.error("Failed to initialize the data cache!", (Throwable)e);
        }
    }

    @Nullable
    public static DataCache load() {
        DataCache.init();
        DataCache cache = null;
        try (FileReader reader = new FileReader(path);){
            cache = (DataCache)GSON.fromJson((Reader)reader, DataCache.class);
            OpenLoader.LOGGER.debug("Loaded cache.");
        }
        catch (IOException e) {
            OpenLoader.LOGGER.error("Could not read cache file!", (Throwable)e);
        }
        return cache != null ? cache : new DataCache();
    }
}

