/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import java.util.List;
import java.util.function.Function;
import net.darkhax.openloader.Configuration;
import net.darkhax.openloader.DataCache;
import net.darkhax.openloader.OpenLoaderPackFinder;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="openloader")
public final class OpenLoader {
    public static final Logger LOGGER = LogManager.getLogger((String)"Open Loader");
    public static final Configuration CONFIG = new Configuration();
    public static final DataCache CACHE = DataCache.load();

    public OpenLoader() {
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.DISPLAYTEST, () -> Pair.of(() -> "OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31", (a, b) -> true));
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CONFIG.getSpec());
        CONFIG.forceLoad(FMLPaths.CONFIGDIR.get().resolve("openloader-common.toml"));
        if (FMLEnvironment.dist == Dist.CLIENT) {
            Minecraft.func_71410_x().func_195548_H().addPackFinder((IPackFinder)OpenLoaderPackFinder.RESOUCE);
        }
    }

    private void onServerStart(FMLServerAboutToStartEvent event) {
        event.getServer().func_195561_aH().addPackFinder((IPackFinder)OpenLoaderPackFinder.DATA);
    }

    public static void injectDatapackFinder(ResourcePackList resourcePacks) {
        if (((Boolean)DistExecutor.unsafeRunForDist(() -> () -> resourcePacks != Minecraft.func_71410_x().func_195548_H(), () -> () -> true)).booleanValue()) {
            resourcePacks.addPackFinder((IPackFinder)OpenLoaderPackFinder.DATA);
            LOGGER.info("Injecting data pack finder.");
        }
    }

    public static void attemptForceLoad(ResourcePackInfo packInfo, List<ResourcePackInfo> toEnable) {
        OpenLoaderPackFinder.Type packType;
        if (FMLEnvironment.dist == Dist.CLIENT && (packType = OpenLoaderPackFinder.Type.getPackType(packInfo)) == OpenLoaderPackFinder.Type.RESOURCES && !CACHE.isCached(packType, packInfo.func_195790_f())) {
            OpenLoaderPackFinder.PackMeta meta = OpenLoaderPackFinder.getPackMeta(packInfo.func_195790_f(), (Supplier<IResourcePack>)((Supplier)() -> ((ResourcePackInfo)packInfo).func_195796_e()));
            if (meta != null && meta.defaultEnabled && !toEnable.contains(packInfo)) {
                packInfo.func_195792_i().func_198993_a(toEnable, (Object)packInfo, (Function)Functions.identity(), false);
                LOGGER.debug("Force enabling " + packInfo.func_195790_f());
                CACHE.cache(packType, packInfo.func_195790_f());
            }
        }
    }
}

