/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.darkhax.openloader.OpenLoader;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;

public final class OpenLoaderPackFinder
implements IPackFinder {
    private static final IMetadataSectionSerializer<PackMeta> META_SERIALIZER = new PackMetaSerializer();
    public static final OpenLoaderPackFinder DATA = new OpenLoaderPackFinder(Type.DATA);
    public static final OpenLoaderPackFinder RESOUCE = new OpenLoaderPackFinder(Type.RESOURCES);
    private final Type type;
    private final File loaderDirectory;

    private OpenLoaderPackFinder(Type type) {
        this.type = type;
        this.loaderDirectory = new File(type.path);
        try {
            Files.createDirectories(this.loaderDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            OpenLoader.LOGGER.error("Failed to initialize loader.", (Throwable)e);
        }
    }

    public void func_230230_a_(Consumer<ResourcePackInfo> packs, ResourcePackInfo.IFactory factory) {
        if (!this.type.enabled.getAsBoolean()) {
            OpenLoader.LOGGER.info("{} loading has been disabled via the config.", (Object)this.type.displayName);
            return;
        }
        for (File packCandidate : OpenLoaderPackFinder.getFilesFromDir(this.loaderDirectory)) {
            boolean isFolderPack;
            boolean isFilePack = packCandidate.isFile() && packCandidate.getName().endsWith(".zip");
            boolean bl = isFolderPack = !isFilePack && packCandidate.isDirectory() && new File(packCandidate, "pack.mcmeta").isFile();
            if (isFilePack || isFolderPack) {
                String packName = this.type.path + "/" + packCandidate.getName();
                Supplier<IResourcePack> pack = this.getAsPack(packCandidate);
                PackMeta meta = OpenLoaderPackFinder.getPackMeta(packName, pack);
                OpenLoader.LOGGER.info("Loading {} {}.", (Object)this.type.displayName, (Object)packName);
                OpenLoader.LOGGER.debug("Loading {} with {}.", (Object)packName, (Object)meta);
                ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)packName, (boolean)meta.isBuiltIn, pack, (ResourcePackInfo.IFactory)factory, (ResourcePackInfo.Priority)meta.priority, (IPackNameDecorator)IPackNameDecorator.field_232625_a_);
                if (packInfo == null) continue;
                packs.accept(packInfo);
                continue;
            }
            OpenLoader.LOGGER.error("Failed to load {} from {}. Archive packs must be zips. Folder packs must have a valid pack.mcmeta file.", (Object)this.type.displayName, (Object)packCandidate.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PackMeta getPackMeta(String packName, Supplier<IResourcePack> pack) {
        try (IResourcePack packData = (IResourcePack)pack.get();){
            PackMeta meta = (PackMeta)packData.func_195760_a(META_SERIALIZER);
            if (meta == null) return new PackMeta(true, ResourcePackInfo.Priority.TOP, true);
            PackMeta packMeta = meta;
            return packMeta;
        }
        catch (IOException e) {
            OpenLoader.LOGGER.warn("Could not load pack meta from {}!", (Object)packName);
            OpenLoader.LOGGER.catching((Throwable)e);
        }
        return new PackMeta(true, ResourcePackInfo.Priority.TOP, true);
    }

    private Supplier<IResourcePack> getAsPack(File file) {
        return file.isDirectory() ? () -> new FolderPack(file) : () -> new FilePack(file);
    }

    private static File[] getFilesFromDir(File file) {
        File[] files = new File[]{};
        if (file == null) {
            OpenLoader.LOGGER.error("Attempted to read from a null file.");
        } else if (!file.isDirectory()) {
            OpenLoader.LOGGER.error("Can not read from {}. It's not a directory.", (Object)file.getAbsolutePath());
        } else {
            try {
                File[] readFiles = file.listFiles();
                if (readFiles == null) {
                    OpenLoader.LOGGER.error("Could not read from {} due to a system error. This is likely an issue with your computer.", (Object)file.getAbsolutePath());
                } else {
                    files = readFiles;
                }
            }
            catch (SecurityException e) {
                OpenLoader.LOGGER.error("Could not read from {}. Blocked by system level security. This is likely an issue with your computer.", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        return files;
    }

    public static class PackMeta {
        public final boolean isBuiltIn;
        public final ResourcePackInfo.Priority priority;
        public final boolean defaultEnabled;

        public PackMeta(boolean isBuiltIn, ResourcePackInfo.Priority priority, boolean defaultEnabled) {
            this.isBuiltIn = isBuiltIn;
            this.priority = priority;
            this.defaultEnabled = defaultEnabled;
        }

        public String toString() {
            return "PackMeta [isBuiltIn=" + this.isBuiltIn + ", priority=" + this.priority + ", defaultEnabled=" + this.defaultEnabled + "]";
        }
    }

    static class PackMetaSerializer
    implements IMetadataSectionSerializer<PackMeta> {
        PackMetaSerializer() {
        }

        public String func_110483_a() {
            return "openloader";
        }

        public PackMeta deserialize(JsonObject json) {
            boolean builtin = JSONUtils.func_151209_a((JsonObject)json, (String)"builtin", (boolean)true);
            String priorityName = JSONUtils.func_151219_a((JsonObject)json, (String)"priority", (String)"top").toLowerCase();
            ResourcePackInfo.Priority priority = "top".equalsIgnoreCase(priorityName) ? ResourcePackInfo.Priority.TOP : ("bottom".equalsIgnoreCase(priorityName) ? ResourcePackInfo.Priority.BOTTOM : null);
            boolean defaultEnabled = JSONUtils.func_151209_a((JsonObject)json, (String)"defaultEnabled", (boolean)true);
            if (priority == null) {
                throw new JsonParseException("Expected priority to be \"top\" or \"bottom\". " + priorityName + " is not a valid value!");
            }
            return new PackMeta(builtin, priority, defaultEnabled);
        }
    }

    public static enum Type {
        DATA("Data Pack", "openloader/data", OpenLoader.CONFIG::allowDataPacks),
        RESOURCES("Resource Pack", "openloader/resources", OpenLoader.CONFIG::allowResourcePacks);

        final String displayName;
        final String path;
        final BooleanSupplier enabled;

        private Type(String name, String path, BooleanSupplier enabled) {
            this.displayName = name;
            this.path = path;
            this.enabled = enabled;
        }

        @Nullable
        public static Type getPackType(ResourcePackInfo pack) {
            String packName = pack.func_195790_f();
            for (Type type : Type.values()) {
                if (!packName.startsWith(type.path)) continue;
                return type;
            }
            return null;
        }

        public static boolean isOpenLoaderPack(ResourcePackInfo pack) {
            return Type.getPackType(pack) != null;
        }
    }
}

